/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.runtime.util.StringUtil;
import java.io.File;

class LauncherReplacementCallback
implements StringUtil.ReplacementCallback {
    private String exeBaseDir;
    private File installerTempDir;

    public LauncherReplacementCallback(File exeBaseDir, File installerTempDir) {
        this.exeBaseDir = FileUtil.getCanonicalPath(exeBaseDir) + File.separator;
        this.installerTempDir = installerTempDir;
    }

    @Override
    public String getReplacement(String token2, Object memento, boolean hasFallback) {
        if (token2.equals("launcher:sys.launcherDirectory")) {
            return this.exeBaseDir;
        }
        if (token2.equals("launcher:sys.pathlistSeparator")) {
            return ":";
        }
        if (token2.equals("launcher:sys.tempDir")) {
            return System.getProperty("java.io.tmpdir") + File.separator;
        }
        if (token2.equals("launcher:sys.launcherTempDirectory")) {
            return (this.installerTempDir != null ? this.installerTempDir.getAbsolutePath() : System.getProperty("java.io.tmpdir")) + File.separator;
        }
        if (token2.equals("launcher:sys.jvmHome")) {
            return System.getProperty("java.home") + File.separator;
        }
        return null;
    }
}

