/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32.wininet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class Headers {
    private final Map<String, List<String>> lowerCaseHeaders = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
    private String message;
    private int code = -1;

    Headers() {
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getLowerCaseHeaders() {
        return this.lowerCaseHeaders;
    }

    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public void clear() {
        this.code = -1;
        this.message = null;
        this.lowerCaseHeaders.clear();
        this.headers.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    void parse(byte[] data2) throws IOException {
        if (data2 == null) {
            return;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(data2);
        char[] s = new char[10];
        int firstChar = ((InputStream)input).read();
        while (true) {
            String key;
            int keyEndPos;
            int length;
            block21: {
                int currentChar;
                boolean inKey;
                if (firstChar != 10 && firstChar != 13 && firstChar >= 0) {
                    length = 0;
                    keyEndPos = -1;
                    inKey = firstChar > 32;
                    s[length++] = (char)firstChar;
                } else {
                    return;
                }
                while ((currentChar = ((InputStream)input).read()) >= 0) {
                    switch (currentChar) {
                        case 58: {
                            if (inKey && length > 0) {
                                keyEndPos = length;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            currentChar = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstChar = ((InputStream)input).read();
                            if (currentChar == 13 && firstChar == 10 && (firstChar = ((InputStream)input).read()) == 13) {
                                firstChar = ((InputStream)input).read();
                            }
                            if (firstChar == 10 || firstChar == 13 || firstChar > 32) break block21;
                            currentChar = 32;
                        }
                    }
                    if (length >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, length);
                        s = ns;
                    }
                    s[length++] = (char)currentChar;
                }
                firstChar = -1;
            }
            while (length > 0 && s[length - 1] <= ' ') {
                --length;
            }
            if (keyEndPos <= 0) {
                key = null;
                keyEndPos = 0;
            } else {
                key = String.copyValueOf(s, 0, keyEndPos);
                if (keyEndPos < length && s[keyEndPos] == ':') {
                    ++keyEndPos;
                }
                while (keyEndPos < length && s[keyEndPos] <= ' ') {
                    ++keyEndPos;
                }
            }
            String value = keyEndPos >= length ? "" : String.copyValueOf(s, keyEndPos, length - keyEndPos);
            if (key == null) {
                if (!this.headers.isEmpty()) continue;
                this.parseStatusLine(value);
                continue;
            }
            this.addHeaderValue(key.toLowerCase(Locale.ROOT), value, this.lowerCaseHeaders);
            this.addHeaderValue(key, value, this.headers);
        }
    }

    private void addHeaderValue(String key, String value, Map<String, List<String>> headers) {
        headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    private void parseStatusLine(String statusLine) {
        int spacePos;
        if (statusLine != null && statusLine.startsWith("HTTP/1.") && (spacePos = statusLine.indexOf(32)) > 0) {
            int messagePos = statusLine.indexOf(32, spacePos + 1);
            if (messagePos > 0 && messagePos < statusLine.length()) {
                this.message = statusLine.substring(messagePos + 1);
            }
            if (messagePos < 0) {
                messagePos = statusLine.length();
            }
            try {
                this.code = Integer.parseInt(statusLine.substring(spacePos + 1, messagePos));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "Headers{headers=" + this.headers + ", message='" + this.message + '\'' + ", code=" + this.code + '}';
    }
}

