/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.platform.JVMLocator;
import com.install4j.runtime.installer.platform.unix.UnixJVMLocator;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.PE32Handler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WinJVMLocator {
    private static final String[] REGKEY_JAVASOFT_JDK = new String[]{"SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\JDK"};
    private static final String[] REGKEY_JAVASOFT_JRE = new String[]{"SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\JavaSoft\\JRE"};
    private static final String REGVAL_JAVAHOME = "JavaHome";
    public static final String[] JDK_FILES = new String[]{"bin/javac.exe"};
    public static final String JAVA_EXECUTABLE = "bin/java.exe";

    public static Collection<JVMLocator.JVMLocation> getJVMLocations(boolean allMachines) {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        if (allMachines) {
            WinJVMLocator.addJvms(ret, RegistryView.BIT32, PE32Handler.Machine.UNKNOWN);
            WinJVMLocator.addJvms(ret, RegistryView.BIT64, PE32Handler.Machine.UNKNOWN);
            ret.addAll(WinJVMLocator.getSharedJRES(PE32Handler.Machine.UNKNOWN));
        } else {
            PE32Handler.Machine currentMachine = PE32Handler.getJREMachine();
            WinJVMLocator.addJvms(ret, RegistryView.DEFAULT, currentMachine);
            ret.addAll(WinJVMLocator.getSharedJRES(currentMachine));
        }
        return ret;
    }

    private static void addJvms(Set<JVMLocator.JVMLocation> ret, RegistryView registryView, PE32Handler.Machine requiredMachine) {
        for (String jdkKey : REGKEY_JAVASOFT_JDK) {
            ret.addAll(WinJVMLocator.getFromKey(jdkKey, registryView, true, requiredMachine));
        }
        for (String jreKey : REGKEY_JAVASOFT_JRE) {
            ret.addAll(WinJVMLocator.getFromKey(jreKey, registryView, false, requiredMachine));
        }
    }

    private static Collection<JVMLocator.JVMLocation> getSharedJRES(PE32Handler.Machine requiredMachine) {
        ArrayList<JVMLocator.JVMLocation> ret = new ArrayList<JVMLocator.JVMLocation>();
        File baseDir = new File(FolderInfo.getCommonFilesDirectory(), "i4j_jres");
        for (String sharedLocation : UnixJVMLocator.getSharedLocations(baseDir.getAbsolutePath())) {
            WinJVMLocator.addSharedJres(ret, new File(sharedLocation), requiredMachine);
        }
        return ret;
    }

    private static void addSharedJres(List<JVMLocator.JVMLocation> ret, File parent2, PE32Handler.Machine requiredMachine) {
        File[] files = parent2.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.getName().startsWith("jre") || !WinJVMLocator.checkExecutable(file, requiredMachine)) continue;
                JVMLocator.JVMLocation jvmLocation = new JVMLocator.JVMLocation();
                jvmLocation.setJavaHome(file);
                jvmLocation.setVersion(file.getName());
                ret.add(jvmLocation);
            }
        }
    }

    private static Collection<JVMLocator.JVMLocation> getFromKey(String keyName, RegistryView registryView, boolean jdk, PE32Handler.Machine requiredMachine) {
        HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation> ret = new HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation>();
        String[] subKeys = WinRegistry.getSubKeyNames(RegistryRoot.HKEY_LOCAL_MACHINE, keyName, registryView);
        if (subKeys != null) {
            for (String subKey : subKeys) {
                String javaHome;
                Object javaHomeObject = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, keyName + "\\" + subKey, REGVAL_JAVAHOME, registryView);
                if (!(javaHomeObject instanceof String) || !WinJVMLocator.checkExecutable(new File(javaHome = (String)javaHomeObject), requiredMachine)) continue;
                JVMLocator.JVMLocation jvmLocation = new JVMLocator.JVMLocation();
                jvmLocation.setVersion(subKey);
                jvmLocation.setJavaHome(new File(javaHome));
                jvmLocation.setJDK(jdk);
                JVMLocator.JVMLocation oldJvmLocation = (JVMLocator.JVMLocation)ret.get(jvmLocation);
                if (oldJvmLocation != null && oldJvmLocation.getVersion().length() >= jvmLocation.getVersion().length()) continue;
                ret.put(jvmLocation, jvmLocation);
            }
        }
        return ret.values();
    }

    private static boolean checkExecutable(File javaHome, PE32Handler.Machine requiredMachine) {
        File javaExecutable = new File(javaHome, "bin\\java.exe");
        if (javaExecutable.isFile()) {
            if (requiredMachine == PE32Handler.Machine.UNKNOWN) {
                return true;
            }
            try {
                return requiredMachine == PE32Handler.getMachine(javaExecutable);
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }
}

