/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.win32.Common;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Objects;

public class WinGuiHelper {
    private static Method getHwndMethod;

    private static native Object getPeer0(Window var0, Class<?> var1);

    private static native long getHwnd0(Object var0, Method var1);

    private static native void destroyHIcon0(long var0);

    private static native long createHIcon0(byte[] var0, int var1, int var2);

    private static native void flashWindow0(long var0, boolean var2);

    public static void destroyHIcon(long hicon) {
        if (Util.isWindows() && hicon != 0L) {
            WinGuiHelper.destroyHIcon0(hicon);
        }
    }

    public static long createHIcon(byte[] data2, int desiredWidth, int desiredHeight) {
        if (Util.isWindows() && data2 != null) {
            return WinGuiHelper.createHIcon0(data2, desiredWidth, desiredHeight);
        }
        return 0L;
    }

    public static void flashWindow(long hwnd) {
        if (Util.isWindows() && hwnd != 0L) {
            WinGuiHelper.flashWindow0(hwnd, true);
        }
    }

    public static synchronized long getHwnd(Window window) throws HeadlessException {
        if (window != null) {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            if (!Util.isWindows()) {
                return 0L;
            }
            try {
                Object componentPeer = WinGuiHelper.getPeer0(window, Component.class);
                if (componentPeer != null) {
                    if (getHwndMethod == null && !Objects.equals((getHwndMethod = componentPeer.getClass().getMethod("getHWnd", new Class[0])).getReturnType(), Long.TYPE)) {
                        getHwndMethod = null;
                    }
                    if (getHwndMethod != null) {
                        return WinGuiHelper.getHwnd0(componentPeer, getHwndMethod);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0L;
    }

    static {
        Common.init();
    }
}

