/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.windows.WinFirewall;
import com.install4j.runtime.installer.platform.win32.Common;
import java.util.Collection;
import java.util.EnumSet;

public class Win32Firewall {
    public static final int DIRECTION_INCOMING = 1;
    public static final int DIRECTION_OUTGOING = 2;
    public static final int PROTOCOL_TCP = 6;
    public static final int PROTOCOL_UDP = 17;
    public static final int PROFILE_DOMAIN = 1;
    public static final int PROFILE_PRIVATE = 2;
    public static final int PROFILE_PUBLIC = 4;
    private static ThreadLocal initializer;

    private static synchronized native void initialize0();

    private static native int addRule0(String var0, String var1, String var2, int var3, int var4, String var5, String var6, String var7, String var8, String var9, int var10, boolean var11);

    private static native int deleteRules0(String var0, String var1, String var2, int var3, int var4, String var5, String var6, String var7, String var8, String var9);

    private static native long getCurrentProfileTypes0();

    private static void initialize() {
        initializer.get();
    }

    public static int getProfiles(Collection<WinFirewall.ProfileType> profileTypes, boolean onlyActiveProfiles, boolean avoidPublicProfile) throws WinFirewall.AccessDeniedException, WinFirewall.FirewallException {
        int profiles = 0;
        for (WinFirewall.ProfileType profileType : profileTypes) {
            switch (profileType) {
                case DOMAIN: {
                    profiles |= 1;
                    break;
                }
                case PRIVATE: {
                    profiles |= 2;
                    break;
                }
                case PUBLIC: {
                    profiles |= 4;
                }
            }
        }
        int activeProfiles = -1;
        if (onlyActiveProfiles) {
            activeProfiles = Win32Firewall.getCurrentProfileTypes();
            profiles &= activeProfiles;
        }
        if (avoidPublicProfile) {
            if (activeProfiles == -1) {
                activeProfiles = Win32Firewall.getCurrentProfileTypes();
            }
            if (activeProfiles != 4) {
                profiles ^= 4;
            }
        }
        return profiles;
    }

    public static int getCurrentProfileTypes() throws WinFirewall.AccessDeniedException, WinFirewall.FirewallException {
        if (!Util.isWindows()) {
            return 0;
        }
        Win32Firewall.initialize();
        long result2 = Win32Firewall.getCurrentProfileTypes0();
        int returnCode = (int)(result2 >> 32);
        if (returnCode == 0) {
            return (int)(result2 & 0xFFFFFFFFFFFFFFFFL);
        }
        return (Integer)Win32Firewall.throwFirewallException(returnCode);
    }

    public static boolean addRule(String executablePath, String ruleName, String groupName, WinFirewall.RuleDirection ruleDirection, WinFirewall.NetworkProtocol networkProtocol, String description2, String localPorts, String localAddresses, String remotePorts, String remoteAddresses, int profiles, boolean enabled) throws WinFirewall.AccessDeniedException, WinFirewall.FirewallException {
        if (!Util.isWindows()) {
            return false;
        }
        Win32Firewall.initialize();
        int returnCode = Win32Firewall.addRule0(executablePath, ruleName, groupName, Win32Firewall.getRuleDirection(ruleDirection), Win32Firewall.getNetworkProtocol(networkProtocol), description2, Win32Firewall.fill(localPorts), Win32Firewall.fill(localAddresses), Win32Firewall.fill(remotePorts), Win32Firewall.fill(remoteAddresses), profiles, enabled);
        if (returnCode == 0) {
            return true;
        }
        if (returnCode == -1) {
            return false;
        }
        return (Boolean)Win32Firewall.throwFirewallException(returnCode);
    }

    public static int deleteRules(String executablePath, String ruleName, String groupName, WinFirewall.RuleDirection ruleDirection, WinFirewall.NetworkProtocol networkProtocol, String description2, String localPorts, String localAddresses, String remotePorts, String remoteAddresses) throws WinFirewall.AccessDeniedException, WinFirewall.FirewallException {
        if (!Util.isWindows()) {
            return 0;
        }
        Win32Firewall.initialize();
        int returnCode = Win32Firewall.deleteRules0(executablePath, ruleName, groupName, Win32Firewall.getRuleDirection(ruleDirection), Win32Firewall.getNetworkProtocol(networkProtocol), description2, localPorts, localAddresses, remotePorts, remoteAddresses);
        if (returnCode <= 0) {
            return -returnCode;
        }
        return (Integer)Win32Firewall.throwFirewallException(returnCode);
    }

    private static <T> T throwFirewallException(int returnCode) throws WinFirewall.AccessDeniedException, WinFirewall.FirewallException {
        if (returnCode == 1) {
            throw new WinFirewall.AccessDeniedException();
        }
        if (returnCode >= 500) {
            throw new WinFirewall.FirewallException("Invalid property value. (location: " + returnCode + ")");
        }
        throw new WinFirewall.FirewallException("firewall error " + returnCode);
    }

    private static String fill(String str) {
        return str == null ? "" : str;
    }

    private static int getNetworkProtocol(WinFirewall.NetworkProtocol networkProtocol) {
        if (networkProtocol == null) {
            return 0;
        }
        switch (networkProtocol) {
            case TCP: {
                return 6;
            }
            case UDP: {
                return 17;
            }
        }
        throw new RuntimeException("unknown " + (Object)((Object)networkProtocol));
    }

    private static int getRuleDirection(WinFirewall.RuleDirection ruleDirection) {
        if (ruleDirection == null) {
            return 0;
        }
        switch (ruleDirection) {
            case INCOMING: {
                return 1;
            }
            case OUTGOING: {
                return 2;
            }
        }
        throw new RuntimeException("unknown " + (Object)((Object)ruleDirection));
    }

    public static EnumSet<WinFirewall.ProfileType> translate(int profiles) {
        EnumSet<WinFirewall.ProfileType> ret = EnumSet.noneOf(WinFirewall.ProfileType.class);
        if ((profiles & 1) != 0) {
            ret.add(WinFirewall.ProfileType.DOMAIN);
        }
        if ((profiles & 2) != 0) {
            ret.add(WinFirewall.ProfileType.PRIVATE);
        }
        if ((profiles & 4) != 0) {
            ret.add(WinFirewall.ProfileType.PUBLIC);
        }
        return ret;
    }

    static {
        Common.init();
        initializer = ThreadLocal.withInitial(() -> {
            if (Util.isWindows()) {
                Win32Firewall.initialize0();
            }
            return null;
        });
    }
}

