/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class TcpCommunicationBackend
implements CommunicationBackend {
    private static final int START_PORT = 7546;
    private ServerSocket serverSocket;
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;

    @Override
    public boolean writeDataBlock(byte[] bytes) {
        try {
            this.os.writeInt(bytes.length);
            this.os.flush();
            this.os.write(bytes);
            this.os.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public byte[] readDataBlock() {
        try {
            int length = this.is.readInt();
            byte[] ret = new byte[length];
            this.is.readFully(ret);
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String createListener() {
        int port;
        boolean success2 = false;
        for (port = 7546; port < 7746; ++port) {
            try {
                this.serverSocket = new ServerSocket();
                this.serverSocket.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
                success2 = true;
                break;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
        }
        if (!success2) {
            this.serverSocket = null;
            return null;
        }
        try {
            this.serverSocket.setSoTimeout(300000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return String.valueOf(port);
    }

    @Override
    public boolean connect(String identifier) {
        try {
            if (identifier == null) {
                if (this.serverSocket == null) {
                    return false;
                }
                this.socket = this.serverSocket.accept();
            } else {
                int tryCount = 0;
                while (this.socket == null && tryCount++ < 600) {
                    try {
                        this.socket = new Socket(InetAddress.getLoopbackAddress(), Integer.parseInt(identifier));
                    }
                    catch (IOException e) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            if (this.socket != null) {
                this.is = new DataInputStream(this.socket.getInputStream());
                this.os = new DataOutputStream(this.socket.getOutputStream());
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isProcessAlive(int id) {
        return true;
    }

    public int getProcessId() {
        return -1;
    }
}

