/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.Util;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.StringTokenizer;

public class LegacyUnixFileSystem {
    private static final String LINK_ARROW = " -> ";

    public static boolean setMode(int intMode, File destFile) {
        return LegacyUnixFileSystem.setMode(StringUtil.padLeft(Integer.toOctalString(intMode & 0x1FF), '0', 3), destFile, false);
    }

    public static boolean setMode(String mode, File destFile) {
        return LegacyUnixFileSystem.setMode(mode, destFile, false);
    }

    public static boolean setMode(String mode, File destFile, boolean recursive) {
        return LegacyUnixFileSystem.setMode(mode, destFile, recursive, null);
    }

    public static boolean setMode(String mode, File destFile, boolean recursive, StringBuffer output) {
        if (Util.isWindows()) {
            return false;
        }
        if (Boolean.getBoolean("install4j.noDefaultChmod") && Objects.equals(mode, "644")) {
            return true;
        }
        try {
            String destFilePath = LegacyUnixFileSystem.quoteDollarSign(destFile.getAbsolutePath());
            if (recursive) {
                return Execution.executeAndWait(new String[]{"chmod", "-R", mode, destFilePath}, output);
            }
            return Execution.executeAndWait(new String[]{"chmod", mode, destFilePath}, output);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean setMode(String mode, Collection<File> destFiles) {
        if (Util.isWindows()) {
            return false;
        }
        try {
            String[] command2 = new String[destFiles.size() + 2];
            command2[0] = "chmod";
            command2[1] = mode;
            int i = 2;
            for (File file : destFiles) {
                command2[i++] = LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath());
            }
            return Execution.executeAndWait(command2, null);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean createLink(String destFileName, File linkFile) throws IOException {
        if (Util.isWindows()) {
            return false;
        }
        linkFile.delete();
        return Execution.executeAndWait(new String[]{"ln", "-s", LegacyUnixFileSystem.quoteDollarSign(destFileName), LegacyUnixFileSystem.quoteDollarSign(linkFile.getAbsolutePath())}, null);
    }

    public static boolean setOwner(String owner2, File file) {
        if (Util.isWindows()) {
            return false;
        }
        try {
            String executable;
            if (owner2.startsWith(":")) {
                executable = "chgrp";
                owner2 = owner2.substring(1);
            } else {
                executable = "chown";
            }
            return Execution.executeAndWait(new String[]{executable, owner2, LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath())}, null);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static FileInformationImpl getFileInformation(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            StringBuffer output = new StringBuffer();
            String filePath = LegacyUnixFileSystem.quoteDollarSign(file.getAbsolutePath());
            if (!Execution.executeAndWait(new String[]{"ls", "-lad", filePath}, output) || output.length() == 0) {
                return null;
            }
            FileInformationImpl fileInformation = new FileInformationImpl();
            fileInformation.mode = LegacyUnixFileSystem.fromJavaTypeMode(output.substring(1));
            fileInformation.ownerInfo = LegacyUnixFileSystem.getOwnerInfo(output);
            fileInformation.link = output.charAt(0) == 'l';
            if (fileInformation.link) {
                fileInformation.linkTarget = LegacyUnixFileSystem.getLinkTarget(output.toString());
            }
            return fileInformation;
        }
        catch (Exception e) {
            System.err.println("Could not get file information for " + file.getAbsolutePath() + ", exception: " + e.getMessage());
            return null;
        }
    }

    private static String quoteDollarSign(String s) {
        return s.replaceAll("\\$", "\\\\\\$");
    }

    public static int getMode(File file) {
        FileInformationImpl fileInformation = LegacyUnixFileSystem.getFileInformation(file);
        if (fileInformation != null) {
            return fileInformation.getMode();
        }
        return -1;
    }

    public static String getOwnerInfo(File file) {
        FileInformationImpl fileInformation = LegacyUnixFileSystem.getFileInformation(file);
        if (fileInformation != null) {
            return fileInformation.getOwnerInfo();
        }
        return null;
    }

    private static String getLinkTarget(String output) {
        int index2 = output.lastIndexOf(LINK_ARROW);
        if (index2 > -1) {
            return output.substring(index2 + LINK_ARROW.length()).trim();
        }
        return null;
    }

    private static String getOwnerInfo(StringBuffer output) {
        int tokenCount;
        StringBuilder owner2 = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(output.toString(), " ");
        for (tokenCount = 0; tokenizer.hasMoreTokens() && tokenCount < 4; ++tokenCount) {
            String token2 = tokenizer.nextToken();
            if (tokenCount == 2) {
                owner2 = new StringBuilder(token2.trim());
                continue;
            }
            if (tokenCount != 3) continue;
            owner2.append(":").append(token2.trim());
        }
        if (tokenCount == 4 && owner2.length() > 0) {
            return owner2.toString();
        }
        return null;
    }

    public static int fromJavaTypeMode(String javaTypeString) {
        if (javaTypeString.length() < 9) {
            return -1;
        }
        int mode = LegacyUnixFileSystem.getGroupMode(javaTypeString, 0);
        mode += LegacyUnixFileSystem.getGroupMode(javaTypeString, 1);
        return mode += LegacyUnixFileSystem.getGroupMode(javaTypeString, 2);
    }

    private static int getGroupMode(String output, int group) {
        int multiplier = (int)Math.pow(8.0, 2 - group);
        int mode = 0;
        if (output.charAt(0 + group * 3) == 'r') {
            mode += multiplier * 4;
        }
        if (output.charAt(1 + group * 3) == 'w') {
            mode += multiplier * 2;
        }
        if (output.charAt(2 + group * 3) == 'x') {
            mode += multiplier;
        }
        return mode;
    }

    public static String toJavaTypeMode(String octalString) {
        int intValue = Integer.parseInt(octalString, 8);
        return LegacyUnixFileSystem.toJavaTypeMode(intValue);
    }

    public static String toJavaTypeMode(int intValue) {
        StringBuffer ret = new StringBuffer();
        LegacyUnixFileSystem.appendSingleJavaTypeMode((intValue & 0x1C0) >> 6, ret);
        LegacyUnixFileSystem.appendSingleJavaTypeMode((intValue & 0x38) >> 3, ret);
        LegacyUnixFileSystem.appendSingleJavaTypeMode(intValue & 7, ret);
        return ret.toString();
    }

    private static void appendSingleJavaTypeMode(int intValue, StringBuffer ret) {
        if ((intValue & 4) > 0) {
            ret.append("r");
        } else {
            ret.append("-");
        }
        if ((intValue & 2) > 0) {
            ret.append("w");
        } else {
            ret.append("-");
        }
        if ((intValue & 1) > 0) {
            ret.append("x");
        } else {
            ret.append("-");
        }
    }

    public static void main(String[] args2) {
        System.out.println(Integer.toOctalString(LegacyUnixFileSystem.fromJavaTypeMode(LegacyUnixFileSystem.toJavaTypeMode("664"))));
    }

    public static class FileInformationImpl
    implements UnixFileSystem.FileInformation {
        private int mode = -1;
        private String ownerInfo;
        private boolean link;
        private String linkTarget;

        private FileInformationImpl() {
        }

        public FileInformationImpl(int mode, String ownerInfo, boolean link, String linkTarget) {
            this.mode = mode;
            this.ownerInfo = ownerInfo;
            this.link = link;
            this.linkTarget = linkTarget;
        }

        @Override
        public int getMode() {
            return this.mode;
        }

        @Override
        public String getOwnerInfo() {
            return this.ownerInfo;
        }

        @Override
        public boolean isLink() {
            return this.link;
        }

        @Override
        public String getLinkTarget() {
            return this.linkTarget;
        }

        public String toString() {
            return Integer.toOctalString(this.mode) + ", " + this.ownerInfo + ", link: " + this.link + (this.link ? ", target: " + this.linkTarget : "");
        }
    }
}

