/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.ejt.internal.io.StreamConsumerThread;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class Execution {
    public static boolean executeAndWait(String[] command2, StringBuffer output) throws IOException {
        return Execution.executeWithReturnCode(command2, output, false) == 0;
    }

    public static int executeWithReturnCode(String[] command2, StringBuffer output, boolean utf8) throws IOException {
        return Execution.executeWithReturnCode(command2, output, output, utf8);
    }

    public static int executeWithReturnCode(String[] command2, StringBuffer output, StringBuffer error, boolean utf8) throws IOException {
        if (InstallerUtil.isWindows()) {
            Process process2 = new ProcessBuilder(command2).start();
            return Execution.handleProcess(process2, output, error, utf8);
        }
        File scriptFile = File.createTempFile("i4j", ".sh");
        Process process3 = Execution.executeWithScript(command2, scriptFile);
        int ret = Execution.handleProcess(process3, output, error, utf8);
        scriptFile.delete();
        return ret;
    }

    public static Process execute(String[] command2) throws IOException {
        if (InstallerUtil.isMacOS()) {
            File scriptFile = File.createTempFile("i4j", ".sh");
            return Execution.executeWithScript(command2, scriptFile);
        }
        return new ProcessBuilder(command2).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int handleProcess(Process process2, StringBuffer output, StringBuffer error, boolean utf8) throws IOException {
        try {
            StreamConsumerThread.consumeOutput(process2, output, error, utf8);
            int n = process2.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            int n = 1;
            return n;
        }
        finally {
            process2.destroy();
        }
    }

    private static Process executeWithScript(String[] command2, File scriptFile) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(scriptFile)), StandardCharsets.UTF_8));
        pw.println("#!/bin/sh");
        for (int i = 0; i < command2.length; ++i) {
            pw.print("\"" + command2[i] + "\"");
            if (i >= command2.length - 1) continue;
            pw.print(" ");
        }
        pw.println();
        pw.close();
        String[] cmd = new String[]{"/bin/sh", scriptFile.getAbsolutePath()};
        return new ProcessBuilder(cmd).start();
    }
}

