/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.BuildVersionCommand;
import com.install4j.runtime.installer.platform.macos.macho.LinkDataCommand;
import com.install4j.runtime.installer.platform.macos.macho.OpaqueContent;
import com.install4j.runtime.installer.platform.macos.macho.Part;
import com.install4j.runtime.installer.platform.macos.macho.Segment32Command;
import com.install4j.runtime.installer.platform.macos.macho.Segment64Command;
import com.install4j.runtime.installer.platform.macos.macho.SymtabCommand;
import com.install4j.runtime.installer.platform.macos.macho.VersionMinCommand;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LoadCommand {
    public static final int LC_REQ_DYLD = Integer.MIN_VALUE;
    public static final int LC_SEGMENT = 1;
    public static final int LC_SYMTAB = 2;
    public static final int LC_DYSYMTAB = 11;
    public static final int LC_LOAD_DYLIB = 12;
    public static final int LC_ID_DYLIB = 13;
    public static final int LC_SEGMENT_64 = 25;
    public static final int LC_UUID = 27;
    public static final int LC_CODE_SIGNATURE = 29;
    public static final int LC_SEGMENT_SPLIT_INFO = 30;
    public static final int LC_REEXPORT_DYLIB = -2147483617;
    public static final int LC_DYLD_INFO = 34;
    public static final int LC_DYLD_INFO_ONLY = -2147483614;
    public static final int LC_BUILD_VERSION = 50;
    public static final int LC_VERSION_MIN_MACOSX = 36;
    private int cmd;
    private int size;
    private Part content;

    public LoadCommand() {
    }

    public LoadCommand(int cmd, int size2, Part content) {
        this.cmd = cmd;
        this.size = size2;
        this.content = content;
    }

    static int getContentLength(int loadCommandSize) {
        return loadCommandSize - 8;
    }

    public void read(ByteBuffer buf, boolean bit64) throws IOException {
        this.cmd = buf.getInt();
        this.size = buf.getInt();
        this.initContent();
        this.content.read(buf, bit64);
    }

    public void write(ByteBuffer buf, boolean bit64) throws IOException {
        buf.putInt(this.cmd);
        buf.putInt(this.size);
        this.content.write(buf, bit64);
    }

    public int getSize() {
        return this.size;
    }

    private void initContent() {
        int contentLength = LoadCommand.getContentLength(this.size);
        this.content = this.cmd == 29 ? new LinkDataCommand(contentLength) : (this.cmd == 25 ? new Segment64Command(contentLength) : (this.cmd == 1 ? new Segment32Command(contentLength) : (this.cmd == 50 ? new BuildVersionCommand(contentLength) : (this.cmd == 36 ? new VersionMinCommand(contentLength) : (this.cmd == 2 ? new SymtabCommand(contentLength) : new OpaqueContent(contentLength))))));
    }

    public String toString() {
        return "LoadCommand{cmd=" + this.cmd + ", size=" + this.size + ", content=" + this.content + '}';
    }

    public Part getContent() {
        return this.content;
    }

    public int getCmd() {
        return this.cmd;
    }
}

