/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.MachoCpuType;
import com.install4j.runtime.installer.platform.macos.macho.MachoFile;
import com.install4j.runtime.util.BinaryUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class FatMachoFile
implements Closeable {
    public static final int FAT_MAGIC = -889275714;
    public static final int FAT_CIGAM = -1095041334;
    public static final int ALIGNMENT = 4096;
    private int magic;
    private FileChannel channel;
    private RandomAccessFile raFile;
    private List<Architecture> architectures = new ArrayList<Architecture>();

    public FatMachoFile(File file) throws IOException {
        this(file, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FatMachoFile(File file, boolean writeable, boolean createNew) throws IOException {
        if (writeable) {
            this.raFile = new RandomAccessFile(file, "rw");
            this.init(createNew);
        } else {
            try (RandomAccessFile raFile = new RandomAccessFile(file, "r");){
                this.raFile = raFile;
                this.init(createNew);
            }
            finally {
                this.raFile = null;
            }
        }
    }

    private void init(boolean createNew) throws IOException {
        if (createNew) {
            this.magic = -889275714;
            this.channel = this.raFile.getChannel();
        } else {
            this.magic = this.raFile.readInt();
            if (this.isFat()) {
                this.channel = this.raFile.getChannel();
                int number = this.readInt();
                for (int i = 0; i < number; ++i) {
                    Architecture architecture = new Architecture();
                    this.architectures.add(architecture);
                }
            } else {
                this.raFile.close();
            }
        }
    }

    private void writeInt(int v) throws IOException {
        this.raFile.writeInt(this.isBigEndian() ? v : BinaryUtil.swap(v));
    }

    private int readInt() throws IOException {
        int ret = this.raFile.readInt();
        return this.isBigEndian() ? ret : BinaryUtil.swap(ret);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
    }

    public void write() throws IOException {
        this.raFile.seek(0L);
        this.raFile.setLength(0L);
        this.raFile.writeInt(this.magic);
        this.writeInt(this.architectures.size());
        int offset2 = 4096;
        for (Architecture architecture : this.architectures) {
            offset2 = (int)BinaryUtil.align(offset2, 1L << architecture.align);
            offset2 = architecture.write(offset2);
        }
        this.close();
    }

    public List<Architecture> getArchitectures() {
        return this.architectures;
    }

    public boolean isBigEndian() {
        return this.magic == -889275714;
    }

    public boolean isFat() {
        return FatMachoFile.isFatMagic(this.magic);
    }

    public void addArchitecture(MachoFile machoFile) {
        this.architectures.add(new Architecture(machoFile));
    }

    private static boolean isFatMagic(int magic) {
        return magic == -889275714 || magic == -1095041334;
    }

    public static boolean isAnyMacho(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) > 4L) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
                int magic = in.readInt();
                boolean bl = FatMachoFile.isFatMagic(magic) || MachoFile.isThinMagic(magic);
                return bl;
            }
        }
        return false;
    }

    public static boolean isFatMacho(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) > 4L) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
                int magic = in.readInt();
                boolean bl = FatMachoFile.isFatMagic(magic);
                return bl;
            }
        }
        return false;
    }

    public class Architecture {
        private final int cputype;
        private final int cpusubtype;
        private final int align;
        private ByteBuffer data;

        public Architecture(MachoFile machoFile) {
            this.cputype = machoFile.getCpuType();
            this.cpusubtype = machoFile.getCpuSubType();
            MachoCpuType machoCpuType = MachoCpuType.getCpuType(this.cputype);
            this.align = machoCpuType == MachoCpuType.X86_64 || machoCpuType == MachoCpuType.X86 ? 12 : 14;
            this.data = machoFile.getData();
        }

        private Architecture() throws IOException {
            this.cputype = FatMachoFile.this.readInt();
            this.cpusubtype = FatMachoFile.this.readInt();
            int offset2 = FatMachoFile.this.readInt();
            int size2 = FatMachoFile.this.readInt();
            this.align = FatMachoFile.this.readInt();
            long pos = FatMachoFile.this.raFile.getFilePointer();
            FatMachoFile.this.raFile.seek(offset2);
            this.data = ByteBuffer.allocate(size2);
            BinaryUtil.readFully(FatMachoFile.this.channel, this.data);
            FatMachoFile.this.raFile.seek(pos);
        }

        public MachoCpuType getCpuType() {
            return MachoCpuType.getCpuType(this.cputype);
        }

        public ByteBuffer getData() {
            return (ByteBuffer)this.data.duplicate().position(0);
        }

        public void setData(ByteBuffer data2) {
            this.data = data2;
        }

        private int write(int offset2) throws IOException {
            FatMachoFile.this.writeInt(this.cputype);
            FatMachoFile.this.writeInt(this.cpusubtype);
            FatMachoFile.this.writeInt(offset2);
            FatMachoFile.this.writeInt(this.data.limit());
            FatMachoFile.this.writeInt(this.align);
            long pos = FatMachoFile.this.raFile.getFilePointer();
            FatMachoFile.this.raFile.seek(offset2);
            BinaryUtil.writeFully(FatMachoFile.this.channel, this.data);
            FatMachoFile.this.raFile.seek(pos);
            return (int)BinaryUtil.align(offset2 + this.data.limit(), 4096L);
        }

        public String toString() {
            return "Architecture{machocputype=" + (Object)((Object)this.getCpuType()) + ", cputype=" + this.cputype + ", cpusubtype=" + this.cpusubtype + ", align=" + this.align + '}';
        }
    }
}

