/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.Util;
import com.install4j.api.launcher.StartupNotification;
import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import com.install4j.runtime.installer.helper.content.UrlConnectionWrapper;
import com.install4j.runtime.installer.helper.versionspecific.MacApiHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelperInterface;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class NoHelper
implements VersionSpecificHelperInterface {
    @Override
    public boolean isJavaFxWindowShown() {
        try {
            Class<?> stageHelperClass = Class.forName("com.sun.javafx.stage.StageHelper");
            try {
                Field field = stageHelperClass.getDeclaredField("stageAccessor");
                field.setAccessible(true);
                if (field.get(null) == null) {
                    return false;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            Method isShowingMethod = Class.forName("javafx.stage.Window").getMethod("isShowing", new Class[0]);
            Method getStagesMethod = stageHelperClass.getDeclaredMethod("getStages", new Class[0]);
            getStagesMethod.setAccessible(true);
            for (Object stage : (Collection)getStagesMethod.invoke(null, new Object[0])) {
                if (!Boolean.TRUE.equals(isShowingMethod.invoke(stage, new Object[0]))) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void requestForeground() {
        if (Util.isMacOS()) {
            MacApiHelper.requestForeground();
        }
    }

    @Override
    public void setMacStartupListener(StartupNotification.Listener startupListener) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacStartupListener(startupListener);
        }
    }

    @Override
    public void setMacHandleQuit(boolean handleQuit) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacHandleQuit(handleQuit);
        }
    }

    @Override
    public void setMacQuitHandler(Runnable runnable) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacQuitHandler(runnable);
        }
    }

    @Override
    public void setMacAboutHandler(Runnable runnable) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacAboutHandler(runnable);
        }
    }

    @Override
    public void setMacPreferencesHandler(Runnable runnable) {
        if (Util.isMacOS()) {
            MacApiHelper.setMacPreferencesHandler(runnable);
        }
    }

    @Override
    public void addReads(String moduleName) {
    }

    @Override
    public long getPid() {
        return LauncherUtil.getPidFromMBean();
    }

    @Override
    public int waitFor(Process process2, int timeoutSeconds, boolean terminate) throws InterruptedException {
        if (timeoutSeconds > 0) {
            if (process2.waitFor(timeoutSeconds, TimeUnit.SECONDS)) {
                return process2.exitValue();
            }
            if (terminate) {
                process2.destroyForcibly();
            }
            return -10000;
        }
        return process2.waitFor();
    }

    @Override
    public JavaHttpConnection createHttpConnection(URL url, Proxy proxy, boolean acceptAllCertificates) throws IOException {
        return new UrlConnectionWrapper(url, proxy, acceptAllCertificates);
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        System.setSecurityManager(securityManager);
    }

    @Override
    public String getAccessibilityProviderName() {
        return EmptyAccessibility.class.getName();
    }

    public static class EmptyAccessibility {
    }
}

