/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.content.HttpConnection;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import java.text.NumberFormat;

public abstract class TransferFileHandler
extends HttpRequestHandler {
    private NumberFormat largeNumberFormat;
    private NumberFormat numberFormat;
    private ProgressInterface progressInterface;
    private long totalSize;
    private long totalProgress = 0L;
    private String totalSizeVerbose;
    private long fileSize;
    private long currentFileProgress;
    private long startTime;
    private long lastProgressUpdateTime = 0L;
    private boolean progressEnabled = true;

    protected TransferFileHandler(Context context2, ProgressInterface progressInterface) {
        super(context2, context2.isUnattended() && !(progressInterface instanceof UnattendedProgressInterface) ? 3 : (context2.isConsole() ? 2 : 1));
        this.init(progressInterface);
    }

    protected TransferFileHandler(int mode, ProgressInterface progressInterface) {
        super(null, mode);
        this.init(progressInterface);
    }

    protected void init(ProgressInterface progressInterface) {
        this.progressInterface = progressInterface;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumFractionDigits(1);
        this.largeNumberFormat = NumberFormat.getNumberInstance();
        this.largeNumberFormat.setMaximumFractionDigits(0);
        this.totalSize = -1L;
    }

    public void setTotalSize(long totalSize) {
        if (this.progressEnabled) {
            this.totalSize = totalSize;
        }
    }

    public void setProgressEnabled(boolean progressEnabled) {
        this.progressEnabled = progressEnabled;
    }

    public boolean isProgressEnabled() {
        return this.progressEnabled;
    }

    @Override
    protected void connectionInitialized(HttpConnection connection) {
        super.connectionInitialized(connection);
        if (this.progressEnabled) {
            this.currentFileProgress = 0L;
        }
    }

    protected void initProgress(long defaultFileSize) {
        if (this.fileSize == -1L) {
            this.fileSize = defaultFileSize;
        }
        if (this.progressEnabled) {
            if (this.totalSize == -1L) {
                this.totalSize = this.fileSize;
            }
            this.totalSizeVerbose = this.format(this.totalSize, 0x100000L);
            if (this.progressInterface != null) {
                this.progressInterface.setIndeterminateProgress(false);
            }
            this.startTime = System.currentTimeMillis();
            this.currentFileProgress = 0L;
        }
    }

    private String format(long longValue, long divider) {
        double val = (double)longValue / (double)divider;
        return (val >= 1000.0 ? this.largeNumberFormat : this.numberFormat).format(val);
    }

    public void resetLastTransfer() {
        if (this.progressEnabled) {
            this.totalProgress -= this.currentFileProgress;
            this.currentFileProgress = 0L;
        }
    }

    protected void addProgress(long val) {
        if (this.progressEnabled) {
            this.currentFileProgress += val;
            this.totalProgress += val;
        }
    }

    protected long getFileSize() {
        return this.fileSize;
    }

    protected void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    protected long getTotalSize() {
        return this.totalSize;
    }

    protected long getTotalProgress() {
        return this.totalProgress;
    }

    protected void updateProgress(boolean force) {
        if (this.progressInterface == null || !this.progressEnabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.totalSize > 0L && (force || currentTime - this.lastProgressUpdateTime > 500L)) {
            long rate = (long)((double)this.currentFileProgress / (double)(currentTime - this.startTime) * 1000.0);
            this.progressInterface.setDetailMessage(Messages.format(Messages.getString(".DownloadProgress"), this.format(this.totalProgress, 0x100000L), this.totalSizeVerbose, this.format(100L * this.totalProgress, this.totalSize), this.format(rate, 1024L)));
            this.progressInterface.setPercentCompleted((int)(this.totalProgress * 100L / this.totalSize));
            this.lastProgressUpdateTime = currentTime;
        }
    }
}

