/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.console;

import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.console.ConsoleAccess;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class SimpleConsoleAccess
implements ConsoleAccess {
    private static final String EXE4J_PROP_CONSOLE_CODEPAGE = "exe4j.consoleCodepage";
    private static final String INSTALL4J_PROP_CONSOLE_ENCODING = "install4j.consoleEncoding";
    private BufferedReader stdin;
    private PrintWriter stdout;
    private Thread ioThread;

    public SimpleConsoleAccess() {
        String encoding = System.getProperty(INSTALL4J_PROP_CONSOLE_ENCODING);
        if (encoding == null) {
            encoding = System.getProperty(EXE4J_PROP_CONSOLE_CODEPAGE);
        }
        if (encoding == null) {
            this.stdout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
            this.stdin = new BufferedReader(new InputStreamReader(new FileInputStream(FileDescriptor.in)));
        } else {
            try {
                this.stdout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), encoding));
                this.stdin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), encoding));
            }
            catch (UnsupportedEncodingException e) {
                this.stdout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
                this.stdin = new BufferedReader(new InputStreamReader(new FileInputStream(FileDescriptor.in)));
            }
        }
    }

    @Override
    public void print(String text2) {
        this.stdout.print(text2);
    }

    @Override
    public void println(String text2) {
        this.stdout.println(text2);
    }

    @Override
    public void println() {
        this.stdout.println();
    }

    @Override
    public void flush() {
        this.stdout.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(String prompt) throws UserCanceledException {
        this.ioThread = Thread.currentThread();
        try {
            InputReaderThread inputReaderThread = new InputReaderThread();
            inputReaderThread.start();
            try {
                inputReaderThread.join();
                String answer = inputReaderThread.getResult();
                if (answer == null || AbstractHeadlessScreenExecutor.isExitCalled()) {
                    throw new UserCanceledException();
                }
                String string = answer;
                return string;
            }
            catch (InterruptedException e) {
                throw new UserCanceledException();
            }
        }
        finally {
            SimpleConsoleAccess simpleConsoleAccess = this;
            synchronized (simpleConsoleAccess) {
                Thread.interrupted();
                this.ioThread = null;
            }
        }
    }

    @Override
    public String readPassword(String prompt) throws UserCanceledException {
        return this.readLine(prompt);
    }

    @Override
    public void cancel() {
        if (this.ioThread != null) {
            this.ioThread.interrupt();
        }
    }

    private class InputReaderThread
    extends Thread {
        private String result;

        public InputReaderThread() {
            super("console input reader thread");
        }

        public String getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.defaultRead();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.result = "";
            }
            catch (Exception e) {
                this.result = null;
            }
        }

        private void defaultRead() throws IOException {
            int startIndex;
            String rawResult = SimpleConsoleAccess.this.stdin.readLine();
            for (startIndex = 0; startIndex < rawResult.length() && Character.isISOControl(rawResult.charAt(startIndex)); ++startIndex) {
            }
            if (startIndex > 0) {
                rawResult = rawResult.substring(startIndex);
            } else if (startIndex == rawResult.length()) {
                rawResult = "";
            }
            StringBuilder resBuffer = new StringBuilder();
            for (int i = 0; i < rawResult.length(); ++i) {
                if (rawResult.charAt(i) == '\u007f') {
                    if (resBuffer.length() <= 0) continue;
                    resBuffer.setLength(resBuffer.length() - 1);
                    continue;
                }
                resBuffer.append(rawResult.charAt(i));
            }
            this.result = resBuffer.toString();
        }
    }
}

