/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.console;

import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.console.ConsoleAccess;
import com.install4j.runtime.util.DaemonThreadFactory;
import java.io.Console;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class Console16Access
implements ConsoleAccess {
    private PrintWriter stdOut;
    private Console console;
    private volatile boolean cancelled;
    private volatile Future<String> currentReadFuture;
    private ExecutorService readExecutor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("i4j-console-"));

    public Console16Access() {
        this.console = System.console();
        this.stdOut = this.console.writer();
    }

    @Override
    public void print(String text2) {
        if (this.cancelled) {
            System.out.print(text2);
        } else {
            this.stdOut.print(text2);
        }
    }

    @Override
    public void println(String text2) {
        if (this.cancelled) {
            System.out.println(text2);
        } else {
            this.stdOut.println(text2);
        }
    }

    @Override
    public void println() {
        if (this.cancelled) {
            System.out.println();
        } else {
            this.stdOut.println();
        }
    }

    @Override
    public void flush() {
        if (this.cancelled) {
            System.out.flush();
        } else {
            this.console.flush();
        }
    }

    @Override
    public String readLine(String prompt) throws UserCanceledException {
        return this.doRead(() -> this.console.readLine(prompt, new Object[0]));
    }

    @Override
    public String readPassword(String prompt) throws UserCanceledException {
        return this.doRead(() -> {
            char[] chars = this.console.readPassword(prompt, new Object[0]);
            if (chars == null) {
                return null;
            }
            return new String(chars);
        });
    }

    @NotNull
    private String doRead(Callable<String> readCallable) throws UserCanceledException {
        String result2;
        try {
            this.currentReadFuture = this.readExecutor.submit(readCallable);
            result2 = this.currentReadFuture.get();
        }
        catch (InterruptedException | CancellationException e) {
            throw new UserCanceledException();
        }
        catch (ExecutionException e) {
            if (AbstractHeadlessScreenExecutor.isExitCalled()) {
                throw new UserCanceledException();
            }
            throw new RuntimeException(e.getCause());
        }
        finally {
            this.currentReadFuture = null;
        }
        if (result2 == null || AbstractHeadlessScreenExecutor.isExitCalled()) {
            throw new UserCanceledException();
        }
        return result2;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.readExecutor.shutdownNow();
        Future<String> currentReadFuture = this.currentReadFuture;
        if (currentReadFuture != null) {
            currentReadFuture.cancel(true);
        }
    }
}

