/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.applaunch;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.launcher.Variables;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShutdownWaiter
extends Thread {
    @NotNull
    private final File shutdownFile;
    @Nullable
    private final ApplicationLauncher.Callback callback;
    private final Process process;
    private volatile boolean exitCalled;

    ShutdownWaiter(@NotNull File shutdownFile, @Nullable ApplicationLauncher.Callback callback, Process process2) {
        super("_i4j_commfile_waiter");
        this.setDaemon(true);
        this.setPriority(4);
        this.process = process2;
        this.shutdownFile = shutdownFile;
        this.callback = callback;
        shutdownFile.deleteOnExit();
    }

    private boolean isShutdownLauncher() {
        return this.shutdownFile.length() > 0L;
    }

    @Override
    public void run() {
        boolean running = true;
        int exitValue = 0;
        while (!this.exitCalled && running && !this.isShutdownLauncher()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                exitValue = this.process.exitValue();
                running = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        this.exited(exitValue, this.isShutdownLauncher());
    }

    public boolean isExitCalled() {
        return this.exitCalled;
    }

    public synchronized void exited(int exitCode, boolean shutdownLauncher) {
        if (this.exitCalled) {
            return;
        }
        this.exitCalled = true;
        Variables.clearInstallerVariablesCache();
        boolean debug = Boolean.getBoolean("install4j.debugShutdownFile");
        if (debug) {
            System.err.println("application exited");
        }
        if (shutdownLauncher) {
            if (debug) {
                System.err.println("commFile = " + this.shutdownFile);
                System.err.println("commFile.length() = " + this.shutdownFile.length());
            }
            if (this.callback != null) {
                this.callback.prepareShutdown();
            }
            System.exit(0);
        } else if (this.callback != null) {
            this.callback.exited(exitCode);
        }
        this.shutdownFile.delete();
    }
}

