/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.applaunch;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.runtime.installer.helper.applaunch.CommType;
import com.install4j.runtime.installer.helper.applaunch.ShutdownWaiter;
import com.install4j.runtime.installer.helper.comm.InterProcessCommunication;
import com.install4j.runtime.util.DaemonThreadFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

class ParentIPCThread
extends Thread {
    @NotNull
    private final InterProcessCommunication communication;
    @NotNull
    private ApplicationLauncher.ProgressListener progressListener;
    @NotNull
    private ShutdownWaiter shutdownWaiter;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("i4j-progress-exec-"));

    ParentIPCThread(@NotNull InterProcessCommunication communication, @NotNull ShutdownWaiter shutdownWaiter, @NotNull ApplicationLauncher.ProgressListener progressListener) {
        super("_i4j_ipc_thread");
        this.setDaemon(true);
        this.setPriority(4);
        this.communication = communication;
        this.progressListener = progressListener;
        this.shutdownWaiter = shutdownWaiter;
    }

    @Override
    public void run() {
        try {
            if (this.communication.connect()) {
                CommType[] commTypes = CommType.values();
                while (!this.shutdownWaiter.isExitCalled()) {
                    byte[] data2 = this.communication.readDataBlock();
                    DataInputStream din = new DataInputStream(new ByteArrayInputStream(data2));
                    int typeOrdinal = din.readInt();
                    if (typeOrdinal < 0 || typeOrdinal >= commTypes.length) continue;
                    switch (commTypes[typeOrdinal]) {
                        case EXITING: {
                            return;
                        }
                        case SHOW_SCREEN: {
                            String id = din.readUTF();
                            this.executorService.execute(() -> this.progressListener.screenActivated(id));
                            break;
                        }
                        case EXECUTE_ACTION: {
                            String id = din.readUTF();
                            this.executorService.execute(() -> this.progressListener.actionStarted(id));
                            break;
                        }
                        case STATUS_MESSAGE: {
                            String message = din.readUTF();
                            this.executorService.execute(() -> this.progressListener.statusMessage(message));
                            break;
                        }
                        case DETAIL_MESSAGE: {
                            String message = din.readUTF();
                            this.executorService.execute(() -> this.progressListener.detailMessage(message));
                            break;
                        }
                        case PERCENTAGE_COMPLETED: {
                            int value = din.readInt();
                            this.executorService.execute(() -> this.progressListener.percentCompleted(value));
                            break;
                        }
                        case SECONDARY_PERCENTAGE_COMPLETED: {
                            int value = din.readInt();
                            this.executorService.execute(() -> this.progressListener.secondaryPercentCompleted(value));
                            break;
                        }
                        case INDETERMINATE_PROGRESS: {
                            boolean indeterminateProgress = din.readBoolean();
                            this.executorService.execute(() -> this.progressListener.indeterminateProgress(indeterminateProgress));
                            break;
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

