/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.JVMSelector;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.platform.JVMLocator;
import com.install4j.runtime.util.VersionCheck;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class JVMSelectorImpl {
    private JVMSelectorImpl() {
    }

    public static JVMSelector.JVMLocation[] getJVMLocations() {
        return JVMLocator.getJVMLocations(null);
    }

    public static JVMSelector.JVMLocation[] getJVMLocations(String minVersion, String maxVersion, boolean jdkOnly, File[] additionalLocations) {
        JVMLocator.JVMLocation[] locations = JVMLocator.getJVMLocations(additionalLocations);
        ArrayList<JVMLocator.JVMLocation> ret = new ArrayList<JVMLocator.JVMLocation>();
        for (JVMLocator.JVMLocation location : locations) {
            if (!JVMSelectorImpl.checkJVMLocation(location, minVersion, maxVersion, jdkOnly)) continue;
            ret.add(location);
        }
        return ret.toArray(new JVMSelector.JVMLocation[0]);
    }

    public static JVMSelector.JVMLocation getJVMLocation(File javaHome, String minVersion, String maxVersion, boolean jdkOnly) {
        JVMLocator.JVMLocation jvmLocation = JVMLocator.getJVMLocation(javaHome);
        if (JVMSelectorImpl.checkJVMLocation(jvmLocation, minVersion, maxVersion, jdkOnly)) {
            return jvmLocation;
        }
        return null;
    }

    public static void setPreferredJVM(final String javaHome) {
        if (ContextImpl.getSingleContextInt() == null) {
            JVMSelectorImpl.writePreferredJreFile(javaHome);
        } else {
            HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

                @Override
                protected void run(Context context2) {
                    if (InstallerConfig.getCurrentApplication() instanceof InstallerApplication) {
                        ContentInstaller.getInstance().setPreferredJre(javaHome);
                    } else {
                        JVMSelectorImpl.writePreferredJreFile(javaHome);
                    }
                }
            });
        }
    }

    public static void writePreferredJreFile(String javaHome) {
        if (!Util.isMacOS()) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(new File(ResourceHelper.getRuntimeDir(), "pref_jre.cfg")));
                pw.println(javaHome);
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean checkJVMLocation(JVMSelector.JVMLocation location, String minVersion, String maxVersion, boolean jdkOnly) {
        if (location != null && (!jdkOnly || location.isJDK())) {
            String version = location.getVersion();
            if (minVersion == null || VersionCheck.checkCompatible(minVersion, version)) {
                if (maxVersion != null) {
                    if (maxVersion.length() < version.length()) {
                        version = version.substring(0, maxVersion.length());
                    }
                    if (VersionCheck.checkCompatible(version, maxVersion)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }
}

