/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.runtime.util.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EnvironmentUtil {
    private static Map<String, String> env;

    private static Map<String, String> getEnv() {
        if (env == null) {
            Map<String, String> rawEnv = System.getenv();
            env = Util.isWindows() ? EnvironmentUtil.getUpperCaseVariables(rawEnv) : rawEnv;
        }
        return env;
    }

    public static Map<String, String> getUpperCaseVariables(Map<String, String> variables) {
        HashMap<String, String> upperCaseVariables = new HashMap<String, String>(variables.size());
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            upperCaseVariables.put(entry.getKey().toUpperCase(Locale.ENGLISH), entry.getValue());
        }
        return upperCaseVariables;
    }

    public static String replaceEnvironmentVariables(String value, Map<String, String> variables) {
        return StringUtil.replaceVariable(value, (token2, memento, hasFallback) -> (String)variables.get(Util.isWindows() ? token2.toUpperCase(Locale.ENGLISH) : token2));
    }

    public static String replaceEnvironmentVariables(String value) {
        return EnvironmentUtil.replaceEnvironmentVariables(value, EnvironmentUtil.getEnv());
    }
}

