/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.ejt.internal.gui.KeyboardUtil;
import com.install4j.api.Util;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ProgramGroupSelector
extends JPanel {
    private static final String BAD_CHARS = "/:*?\"<>|";
    private boolean allUsers;
    private boolean showWarningIfExists;
    private WizardContext wizardContext;
    private JTextField txtGroup;
    private JList<String> lstGroups;
    private JScrollPane scpGroups;

    public static boolean checkProgramGroup(String programGroup, boolean allUsers, boolean showWarningIfExists, Window parent2) throws UserCanceledException {
        int result2;
        File groupDir;
        char[] badChars;
        if (programGroup.length() == 0) {
            GUIHelper.showMessage(parent2, Messages.getString(".MustEnterGroupName"), 2);
            return false;
        }
        for (char badChar : badChars = BAD_CHARS.toCharArray()) {
            if (programGroup.indexOf(badChar) < 0) continue;
            GUIHelper.showMessage(parent2, Messages.format(Messages.getString(".BadGroupName"), BAD_CHARS), 2);
            return false;
        }
        return !showWarningIfExists || !(groupDir = new File(FolderInfo.getSpecialFolder(3, allUsers), programGroup)).exists() || (result2 = Util.showOptionDialog(Messages.getString(".ProgramGroupExists"), new String[]{Messages.getString(".ButtonYes"), Messages.getString(".ButtonNo")}, 3)) == 0;
    }

    public ProgramGroupSelector(boolean allUsers, boolean showWarningIfExists, WizardContext context2) {
        this.allUsers = allUsers;
        this.showWarningIfExists = showWarningIfExists;
        this.wizardContext = context2;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtGroup.setEnabled(enabled);
        this.lstGroups.setEnabled(enabled);
    }

    public String getSelectedProgramGroup() {
        String programGroup = this.txtGroup.getText().trim();
        while (programGroup.endsWith("\\")) {
            programGroup = programGroup.substring(0, programGroup.length() - 1);
        }
        return programGroup;
    }

    public boolean checkSelectedProgramGroup() {
        try {
            boolean result2 = ProgramGroupSelector.checkProgramGroup(this.getSelectedProgramGroup(), this.allUsers, this.showWarningIfExists, (Window)SwingUtilities.getAncestorOfClass(Window.class, this));
            if (!result2) {
                this.txtGroup.requestFocus();
            }
            return result2;
        }
        catch (UserCanceledException e) {
            return false;
        }
    }

    public void focusTextField() {
        this.txtGroup.requestFocus();
        this.txtGroup.setSelectionStart(0);
        this.txtGroup.setSelectionEnd(this.txtGroup.getDocument().getLength());
    }

    private void setupControls() {
        this.txtGroup = new JTextField("");
        this.lstGroups = new JList();
        this.lstGroups.setModel(new DefaultListModel());
        this.lstGroups.setSelectionMode(0);
        this.scpGroups = new JScrollPane(this.lstGroups);
        this.fillGroupList();
        this.lstGroups.setVisibleRowCount(5);
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        this.add((Component)this.txtGroup, gc);
        ++gc.gridy;
        gc.insets = new Insets(5, 0, 0, 0);
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)this.scpGroups, gc);
    }

    private void setupEventHandlers() {
        this.lstGroups.addListSelectionListener(event -> {
            String selectedValue = this.lstGroups.getSelectedValue();
            if (selectedValue != null) {
                this.txtGroup.setText(selectedValue.toString());
            }
        });
        KeyboardUtil.addAccelerator(0, this.txtGroup, this.txtGroup, event -> this.wizardContext.pressControlButton(ControlButtonType.NEXT), 10, 0);
    }

    private void fillGroupList() {
        if (InstallerUtil.isWindows()) {
            File programsFolder = FolderInfo.getSpecialFolder(3, this.allUsers);
            if (programsFolder == null) {
                return;
            }
            File startupFolder = FolderInfo.getSpecialFolder(4, this.allUsers);
            DefaultListModel<String> model = new DefaultListModel<String>();
            try {
                File[] files;
                if (startupFolder != null) {
                    startupFolder = startupFolder.getCanonicalFile();
                }
                if ((files = programsFolder.listFiles()) == null) {
                    return;
                }
                for (File file : files) {
                    if (file == null || !file.isDirectory() || Objects.equals(file = file.getCanonicalFile(), startupFolder)) continue;
                    model.addElement(file.getName());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lstGroups.setModel(model);
        }
    }

    public void setSelectedProgramGroup(String programGroupName) {
        this.txtGroup.setText(programGroupName);
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
        ((DefaultListModel)this.lstGroups.getModel()).removeAllElements();
        this.fillGroupList();
        this.lstGroups.scrollRectToVisible(new Rectangle());
    }
}

