/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.ejt.internal.gui.ScreenSizeUtil;
import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.AbstractBean;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.screens.Screen;
import com.install4j.api.styles.StyleManager;
import com.install4j.runtime.beans.TextBinder;
import com.install4j.runtime.beans.screens.SystemProgressScreen;
import com.install4j.runtime.beans.styles.StyleManagerImpl;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.WizardContextInt;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.LanguageSelectionDialog;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.RollbackProgressInterface;
import com.install4j.runtime.installer.frontend.ScreenEnvelope;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.WinTaskBar;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class WizardScreenExecutor
extends WizardBase
implements ScreenExecutor,
WizardContextInt {
    private GUIProgressInterface defaultProgressInterface;
    private RollbackProgressInterface rollbackProgressInterface;
    private ScreenEnvelope screenEnvelope;
    private CommandSink commandSink;
    private WizardIndex wizardIndex;
    private String wizardIndexKey;
    private Map<Screen, WizardIndexAndKey> cachedWizardIndexKeys = new HashMap<Screen, WizardIndexAndKey>();
    private boolean dialog;
    private Window parentWindow;
    private Dimension overriddenSize;
    private TextBinder textBinder;
    private String overriddenTitle;

    public WizardScreenExecutor(boolean dialog, Window parentWindow) {
        super("");
        this.dialog = dialog;
        this.parentWindow = parentWindow;
        this.initAWT();
        if (Boolean.getBoolean("install4j.runtime.overrideDisplay")) {
            ScreenSizeUtil.checkOverrideScreenDevice();
        }
        this.defaultProgressInterface = new GUIProgressInterface();
        FileInstaller.getInstance().setDefaultProgressInterface(this.defaultProgressInterface);
        if (Util.isMacOS() && !InstallerUtil.isInProcess()) {
            VersionSpecificHelper.setMacQuitHandler(() -> this.pressControlButton(ControlButtonType.CANCEL));
        }
    }

    @Override
    public void setControlButtonEnabled(ControlButtonType controlButtonType, boolean enabled) {
        this.screenEnvelope.setControlButtonEnabled(controlButtonType, enabled);
    }

    @Override
    public void setControlButtonVisible(ControlButtonType controlButtonType, boolean visible) {
        this.screenEnvelope.setControlButtonVisible(controlButtonType, visible);
    }

    @Override
    public void pressControlButton(ControlButtonType controlButtonType) {
        this.screenEnvelope.pressControlButton(controlButtonType);
    }

    @Override
    public void focusControlButton(ControlButtonType controlButtonType) {
        this.screenEnvelope.focusControlButton(controlButtonType);
    }

    @Override
    public void setControlButtonText(ControlButtonType controlButtonType, String text2) {
        this.screenEnvelope.setControlButtonText(controlButtonType, text2);
    }

    @Override
    @Deprecated
    public void setNextButtonEnabled(boolean enabled) {
        this.setControlButtonEnabled(ControlButtonType.NEXT, enabled);
    }

    @Override
    @Deprecated
    public void setBackButtonEnabled(boolean enabled) {
        this.setControlButtonEnabled(ControlButtonType.PREVIOUS, enabled);
    }

    @Override
    @Deprecated
    public void setCancelButtonEnabled(boolean enabled) {
        this.setControlButtonEnabled(ControlButtonType.CANCEL, enabled);
    }

    @Override
    @Deprecated
    public void setNextButtonVisible(boolean visible) {
        this.setControlButtonVisible(ControlButtonType.NEXT, visible);
    }

    @Override
    @Deprecated
    public void setBackButtonVisible(boolean visible) {
        this.setControlButtonVisible(ControlButtonType.PREVIOUS, visible);
    }

    @Override
    @Deprecated
    public void setCancelButtonVisible(boolean visible) {
        this.setControlButtonVisible(ControlButtonType.CANCEL, visible);
    }

    @Override
    @Deprecated
    public void pressNextButton() {
        this.pressControlButton(ControlButtonType.NEXT);
    }

    @Override
    @Deprecated
    public void pressPreviousButton() {
        this.pressControlButton(ControlButtonType.PREVIOUS);
    }

    @Override
    @Deprecated
    public void pressCancelButton() {
        this.pressControlButton(ControlButtonType.CANCEL);
    }

    @Override
    @Deprecated
    public void focusNextButton() {
        this.focusControlButton(ControlButtonType.NEXT);
    }

    @Override
    @Deprecated
    public void setNextButtonText(String text2) {
        this.setControlButtonText(ControlButtonType.NEXT, text2);
    }

    @Override
    @Deprecated
    public void setPreviousButtonText(String text2) {
        this.setControlButtonText(ControlButtonType.PREVIOUS, text2);
    }

    @Override
    @Deprecated
    public void setCancelButtonText(String text2) {
        this.setControlButtonText(ControlButtonType.CANCEL, text2);
    }

    public WizardIndex getWizardIndex() {
        return this.wizardIndex;
    }

    @Override
    public void setWizardIndex(WizardIndex wizardIndex) {
        this.wizardIndex = wizardIndex;
        this.wizardIndexKey = wizardIndex == null ? null : AbstractBean.replaceVariables(wizardIndex.getInitialKey());
        this.updateWizardIndex();
    }

    @Override
    public void setWizardIndexKey(String key) {
        this.wizardIndexKey = AbstractBean.replaceVariables(key);
        this.updateWizardIndex();
    }

    public void updateWizardIndex() {
        EventQueue.invokeLater(() -> {
            if (this.screenEnvelope != null) {
                this.screenEnvelope.activateWizardIndex();
            }
        });
    }

    @Override
    public StyleManager getStyleManager() {
        return StyleManagerImpl.getInstance();
    }

    @Override
    public void setWindowSize(int width2, int height2) {
        if (width2 == 0 || height2 == 0) {
            this.overriddenSize = null;
        } else {
            this.overriddenSize = new Dimension(width2, height2);
            Window parentWindow = UiUtil.getParentWindow();
            if (parentWindow != null) {
                parentWindow.setSize(width2, height2);
            }
        }
    }

    @Override
    public String getWindowTitle() {
        return this.overriddenTitle;
    }

    @Override
    public void setWindowTitle(String title) {
        Window parentWindow = UiUtil.getParentWindow();
        if (parentWindow != null) {
            this.getTextBinder().bind(title, parentWindow);
        }
        this.overriddenTitle = title;
    }

    protected TextBinder getTextBinder() {
        if (this.textBinder == null) {
            this.textBinder = new TextBinder();
        }
        return this.textBinder;
    }

    @Override
    public Dimension getWindowSize() {
        return this.overriddenSize;
    }

    public String getWizardIndexKey() {
        return this.wizardIndexKey;
    }

    @Override
    public void register(Screen screen, ScreenBeanConfig config2) {
        this.getContext().applyToScreen(screen, config2);
        GUIHelper.invokeOnEDT(() -> this.registerScreen(new ScreenEnvelope(this, screen, config2.getStyleId(), config2)));
    }

    @Override
    public void execute(ScreenBeanConfig screenConfig, CommandSink commandSink, boolean previousPossible, ControllerCommand lastCommand) {
        Screen screen = screenConfig.getOrInstantiateScreen(false);
        if ((lastCommand instanceof GoBackCommand || lastCommand instanceof GoBackInHistoryToScreenCommand) && this.cachedWizardIndexKeys.containsKey(screen)) {
            WizardIndexAndKey wizardIndexAndKey = this.cachedWizardIndexKeys.get(screen);
            this.wizardIndex = wizardIndexAndKey.wizardIndex;
            this.wizardIndexKey = wizardIndexAndKey.key;
        }
        this.setCommandSink(commandSink);
        for (WizardScreen wizardScreen : this.getScreens()) {
            ScreenEnvelope screenEnvelope = (ScreenEnvelope)wizardScreen;
            if (screenEnvelope.getScreen() != screen) continue;
            if (this.screenEnvelope != null) {
                this.screenEnvelope.deactivate();
            }
            this.screenEnvelope = screenEnvelope;
            this.setScreen(screenEnvelope);
            if (!previousPossible) {
                screenEnvelope.setControlButtonVisible(ControlButtonType.PREVIOUS, false);
            }
            if (!this.isShowing()) {
                if (this.dialog) {
                    this.showDialog(this.parentWindow);
                } else {
                    this.showFrame(null);
                }
            }
            return;
        }
        throw new RuntimeException("screen not registered " + screen.toString());
    }

    public void cacheWizardIndexAndKey(Screen screen) {
        this.cachedWizardIndexKeys.put(screen, new WizardIndexAndKey(this.wizardIndex, this.wizardIndexKey));
    }

    @Override
    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    @Override
    public void setCommandSink(CommandSink commandSink) {
        this.commandSink = commandSink;
    }

    @Override
    public ProgressInterface getProgressInterface() {
        return ProgressCommunication.getCurrent().wrap(this.getProgressInterfaceInternal());
    }

    private ProgressInterface getProgressInterfaceInternal() {
        if (this.rollbackProgressInterface != null) {
            return this.rollbackProgressInterface;
        }
        if (this.screenEnvelope != null) {
            ProgressInterface formPanelProgressInterface;
            FormPanel formPanel = this.screenEnvelope.getFormPanel();
            if (formPanel != null && (formPanelProgressInterface = formPanel.findProgressInterface()) != null) {
                return formPanelProgressInterface;
            }
            return this.screenEnvelope.getScreen().getProgressInterface(this.defaultProgressInterface);
        }
        return this.defaultProgressInterface;
    }

    @Override
    public ProgressInterface getDefaultProgressInterface() {
        return this.defaultProgressInterface;
    }

    @Override
    public WizardContextInt getWizardContext() {
        return this;
    }

    @Override
    public void selectLanguage(ReturnToken returnToken) {
        new LanguageSelectionDialog(returnToken).setVisible(true);
    }

    @Override
    public boolean isUnattended() {
        return false;
    }

    @Override
    public boolean isUnattendedAlerts() {
        return false;
    }

    @Override
    public boolean isUnattendedWithProgress() {
        return false;
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    protected int getFrameWidth() {
        ContextImpl context2 = this.getContext();
        String overriddenWidth = context2.getCompilerVariable("__internal.app." + InstallerConfig.getCurrentApplicationId() + ".width");
        if (overriddenWidth != null) {
            return Integer.parseInt(overriddenWidth);
        }
        Dimension windowSize = context2.getWizardContext().getWindowSize();
        if (windowSize != null) {
            return windowSize.width;
        }
        return InstallerConfig.getCurrentApplication().getFrameWidth();
    }

    @Override
    protected int getFrameHeight() {
        ContextImpl context2 = this.getContext();
        String overriddenHeight = context2.getCompilerVariable("__internal.app." + InstallerConfig.getCurrentApplicationId() + ".height");
        if (overriddenHeight != null) {
            return Integer.parseInt(overriddenHeight);
        }
        Dimension windowSize = context2.getWizardContext().getWindowSize();
        if (windowSize != null) {
            return windowSize.height;
        }
        return InstallerConfig.getCurrentApplication().getFrameHeight();
    }

    @Override
    protected boolean needsNextScreenOnVisible() {
        return false;
    }

    @Override
    protected void beforeShow(Window wizardWindow) {
        super.beforeShow(wizardWindow);
        if (wizardWindow instanceof JFrame) {
            JFrame frame = (JFrame)wizardWindow;
            frame.setResizable(InstallerConfig.getCurrentApplication().isResizable());
        } else {
            JDialog dialog = (JDialog)wizardWindow;
            dialog.setResizable(InstallerConfig.getCurrentApplication().isResizable());
        }
        this.getContext().getWizardContext().setWindowTitle(this.getWindowTitle());
    }

    @Override
    protected void beforeHide(Window wizardWindow) {
        super.beforeHide(wizardWindow);
        if (this.rollbackProgressInterface != null && this.rollbackProgressInterface.isVisible()) {
            this.rollbackProgressInterface.setVisible(false);
        }
    }

    @Override
    public boolean isSizeClientArea() {
        return InstallerConfig.getCurrentApplication().isFrameSizeClientArea();
    }

    @Override
    protected boolean isQuitOnWindowClose() {
        if (this.screenEnvelope == null) {
            return true;
        }
        return this.screenEnvelope.isCancelVisible() && this.screenEnvelope.isCancelButtonEnabled();
    }

    @Override
    public boolean isFinishOnWindowClose() {
        if (this.screenEnvelope == null) {
            return false;
        }
        return this.screenEnvelope.isFinishScreen();
    }

    @Override
    public void finishFromCloseButton() {
        this.screenEnvelope.doNext();
    }

    @Override
    public void cancel() {
        this.getContext().runWithSuspendedActions(() -> {
            if (GUIHelper.confirmCancel(this)) {
                this.cancelImmediately();
            }
        });
    }

    @Override
    public void cancelImmediately() {
        this.screenEnvelope.setControlButtonEnabled(ControlButtonType.CANCEL, false);
        ContextImpl.setCancelling();
        this.commandSink.returnToController(ControllerCommand.CANCEL);
    }

    @Override
    public void actionsCompleted() {
        SwingUtilities.invokeLater(() -> WinTaskBar.getTaskBar(GUIHelper.getParentWindow()).setProgressState(WinTaskBar.ProgressState.NOPROGRESS));
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        this.setMinimumSize(new Dimension(500, 300));
    }

    @Override
    public void setRollback() {
        if (this.screenEnvelope != null && this.screenEnvelope.getScreen() instanceof SystemProgressScreen) {
            ProgressInterface progressInterface = this.getProgressInterface();
            progressInterface.setIndeterminateProgress(false);
            progressInterface.setDetailMessage("");
            progressInterface.setStatusMessage(Messages.getString(".StatusRollback"));
            progressInterface.setPercentCompleted(0);
        } else if (this.rollbackProgressInterface == null) {
            Runnable runnable = () -> {
                this.rollbackProgressInterface = new RollbackProgressInterface(this.getWizardWindow());
                this.rollbackProgressInterface.setVisible(true);
            };
            GUIHelper.invokeOnEDT(runnable);
        }
    }

    @Override
    public void closeWindows() {
        this.finish();
    }

    @Override
    public ActionCallback getActionCallback() {
        return this.screenEnvelope;
    }

    @Override
    public void initializeLazilyLoadedScreens() {
        for (WizardScreen wizardScreen : this.getScreens()) {
            ((ScreenEnvelope)wizardScreen).initializeLazilyLoaded();
        }
    }

    private void initAWT() {
        if (SwingUtilities.isEventDispatchThread()) {
            new Button();
        } else {
            try {
                SwingUtilities.invokeAndWait(Button::new);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                e.printStackTrace();
            }
        }
    }

    public void disarmButtons() {
        if (this.screenEnvelope != null) {
            this.screenEnvelope.disarmButtons();
        }
    }

    private static class WizardIndexAndKey {
        private WizardIndex wizardIndex;
        private String key;

        private WizardIndexAndKey(WizardIndex wizardIndex, String key) {
            this.wizardIndex = wizardIndex;
            this.key = key;
        }
    }
}

