/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.util.PercentScaler;
import java.io.File;

public class ProgressAdapter
implements ProgressInterface,
FileUtil.CopyProgressListener {
    private ProgressInterface progressInterface;
    private PercentScaler percentScaler;
    private boolean filterProgress = false;
    private long maxCopyProgress;
    private long currentCopyProgress = 0L;

    public ProgressAdapter(ProgressInterface progressInterface, boolean filterProgress) {
        this.progressInterface = progressInterface;
        this.filterProgress = filterProgress;
        this.percentScaler = new PercentScaler(0, 100);
    }

    public ProgressAdapter(ProgressInterface progressInterface, int fromPercent, int toPercent) {
        this.progressInterface = progressInterface;
        this.percentScaler = new PercentScaler(fromPercent, toPercent);
    }

    @Override
    public void setStatusMessage(String message) {
        if (this.progressInterface != null) {
            this.progressInterface.setStatusMessage(message);
        }
    }

    @Override
    public void setDetailMessage(String message) {
        if (this.progressInterface != null) {
            this.progressInterface.setDetailMessage(message);
        }
    }

    @Override
    public void setPercentCompleted(int val) {
        if (!this.filterProgress && this.progressInterface != null) {
            this.progressInterface.setPercentCompleted(val == -1 ? -1 : this.percentScaler.scalePercent(val));
        }
    }

    @Override
    public int getPercentCompleted() {
        if (!this.filterProgress && this.progressInterface != null) {
            return this.progressInterface.getPercentCompleted();
        }
        return 0;
    }

    @Override
    public void setSecondaryPercentCompleted(int val) {
        if (!this.filterProgress && this.progressInterface != null) {
            this.progressInterface.setSecondaryPercentCompleted(val);
        }
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
        if (!this.filterProgress && this.progressInterface != null) {
            this.progressInterface.setIndeterminateProgress(indeterminateProgress);
        }
    }

    @Override
    public void showFailure(String message) {
        if (this.progressInterface != null) {
            this.progressInterface.showFailure(message);
        }
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        if (this.progressInterface != null) {
            return this.progressInterface.askOverwrite(file);
        }
        return 1;
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        if (this.progressInterface != null) {
            return this.progressInterface.askRetry(file);
        }
        return 1;
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        if (this.progressInterface != null) {
            return this.progressInterface.askContinue(file);
        }
        return true;
    }

    public void setMaxCopyProgress(long maxCopyProgress) {
        this.maxCopyProgress = maxCopyProgress;
    }

    @Override
    public boolean progressPerformed(long val) {
        this.currentCopyProgress += val;
        this.setPercentCompleted((int)((double)(100L * this.currentCopyProgress) / (double)this.maxCopyProgress));
        ContextInt context2 = ContextImpl.getSingleContextInt();
        if (context2 == null) {
            return true;
        }
        return !context2.isCancelling();
    }
}

