/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.ejt.internal.gui.HiDPIUtil;
import com.install4j.api.Util;
import com.install4j.api.laf.LookAndFeelHandler;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.AlphaTriStateCheckBox;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class NativeLookAndFeelHandler
implements LookAndFeelHandler {
    public static final Color WINDOWS_TITLE_COLOR = new Color(0, 51, 153);
    private static Font alertFont;
    private static String[] availableFontFamilyNames;
    private Boolean dark;

    private static boolean isGtkLaF() {
        return Objects.equals(UIManager.getLookAndFeel().getID(), "GTK");
    }

    private static boolean isWindowsLaF() {
        return Objects.equals(UIManager.getLookAndFeel().getID(), "Windows");
    }

    private static boolean isWindowsClassicLaF() {
        return NativeLookAndFeelHandler.isWindowsLaF() && (!Objects.equals(Boolean.TRUE, Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) || Boolean.getBoolean("swing.noxp") || UIManager.getLookAndFeel().getClass().getName().endsWith("WindowsClassicLookAndFeel"));
    }

    public static boolean isDarkMode() {
        return !NativeLookAndFeelHandler.isDarkColor(UIManager.getColor("Label.foreground"));
    }

    private static boolean isDarkColor(Color color2) {
        return (30 * color2.getRed() + 59 * color2.getGreen() + 11 * color2.getBlue()) / 100 < 130;
    }

    @NotNull
    private static String getAlertFontName() {
        Locale locale = Locale.getDefault();
        if (locale.equals(new Locale("zh", "CN"))) {
            return "Microsoft YaHei UI";
        }
        if (locale.equals(new Locale("zh", "TW"))) {
            return "Microsoft JhengHei UI";
        }
        if (locale.getLanguage().equals(new Locale("ko").getLanguage())) {
            return "Malgun Gothic";
        }
        if (locale.getLanguage().equals(new Locale("ja").getLanguage())) {
            return "Meiryo UI";
        }
        return "Segoe UI";
    }

    private static boolean isFontInstalled(@NotNull String familyName) {
        if (availableFontFamilyNames == null) {
            GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
            availableFontFamilyNames = g.getAvailableFontFamilyNames();
        }
        for (String name : availableFontFamilyNames) {
            if (!name.equals(familyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyLookAndFeel(boolean darkDesktop) throws Exception {
        if (Util.isWindows() || Util.isMacOS() || HiDPIUtil.getDefaultDeviceScaleFactor() == 1.0) {
            if (!InstallerUtil.isJava9Plus()) {
                System.setProperty("jdk.gtk.version", "2");
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (NativeLookAndFeelHandler.isGtkLaF()) {
                UIManager.put("Button.margin", new Insets(1, 9, 1, 9));
                this.dark = NativeLookAndFeelHandler.isDarkMode();
            }
        }
    }

    @Override
    public boolean isDark() {
        return this.dark != null ? this.dark.booleanValue() : LookAndFeelHandler.super.isDark();
    }

    @Override
    public Color getTitleColor() {
        if (Util.isWindows()) {
            return WINDOWS_TITLE_COLOR;
        }
        return LookAndFeelHandler.super.getTitleColor();
    }

    @Override
    public boolean isWideTreeSelection() {
        return NativeLookAndFeelHandler.isGtkLaF();
    }

    @Override
    public boolean isPreventTransparency(JComponent component) {
        return component instanceof JButton && NativeLookAndFeelHandler.isWindowsClassicLaF();
    }

    @Override
    @NotNull
    public JCheckBox createTriStateCheckBox() {
        if (Util.isMacOS() || NativeLookAndFeelHandler.isWindowsClassicLaF()) {
            return new AlphaTriStateCheckBox(0.5f);
        }
        return LookAndFeelHandler.super.createTriStateCheckBox();
    }

    @Override
    @NotNull
    public Font getAlertFont() {
        if (Util.isWindows()) {
            if (alertFont == null) {
                String fontName = NativeLookAndFeelHandler.getAlertFontName();
                alertFont = Util.isWindows() && NativeLookAndFeelHandler.isFontInstalled(fontName) ? new Font(fontName, 0, 12) : UIManager.getFont("Label.font");
            }
            return alertFont;
        }
        return LookAndFeelHandler.super.getAlertFont();
    }

    @Override
    public int getFileChooserLowerAccessoryInset() {
        return NativeLookAndFeelHandler.isWindowsLaF() ? 100 : LookAndFeelHandler.super.getFileChooserLowerAccessoryInset();
    }
}

