/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.impl.HelperResourceBundle;
import com.install4j.runtime.util.DefaultPropertyResourceBundle;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class Messages {
    public static final String BUNDLE = "com.install4j.runtime.messages.messages";
    private static final String LANGUAGES_MESSAGE_PREFIX = "languages.";
    private static final String MESSAGES_FILE_NAME = "messages_en.utf8";
    private static final String MESSAGES_RESOURCE_DIR = "com/install4j/runtime/messages";
    private static final String MESSAGES_FILE_PATH = "com/install4j/runtime/messages/messages_en.utf8";
    private static VariableResourceBundleWrapper messages;
    private static LanguageConfig languageConfig;

    @NotNull
    public static String getString(@NotNull @PropertyKey(resourceBundle="com.install4j.runtime.messages.messages") String key) {
        return Messages.getMessagesInternal().getString(key);
    }

    public static boolean containsKeyDirectly(@NotNull @PropertyKey(resourceBundle="com.install4j.runtime.messages.messages") String key) {
        return Messages.getMessagesInternal().containsKeyDirectly(key);
    }

    public static String keyWithoutLeadingDot(@NotNull @PropertyKey(resourceBundle="com.install4j.runtime.messages.messages") String key) {
        if (key.startsWith(".")) {
            return key.substring(1);
        }
        return key;
    }

    public static String[] keysWithoutLeadingDot(String ... keys2) {
        String[] keysWithoutLeadingDot = new String[keys2.length];
        for (int i = 0; i < keys2.length; ++i) {
            keysWithoutLeadingDot[i] = Messages.keyWithoutLeadingDot(keys2[i]);
        }
        return keysWithoutLeadingDot;
    }

    public static void usedKeys(String ... keys2) {
    }

    public static void setLanguageConfig(LanguageConfig languageConfig) {
        if (languageConfig == null) {
            throw new IllegalArgumentException("language config cannot be null");
        }
        Messages.languageConfig = languageConfig;
        messages = null;
        GUIHelper.setLanguage(languageConfig.getId());
    }

    public static VariableResourceBundleWrapper getMessagesInternal() {
        if (messages == null) {
            messages = HelperCommunication.getInstance().isElevatedHelper() ? new VariableResourceBundleWrapper(new HelperResourceBundle()) : Messages.createMessages(languageConfig);
        }
        return messages;
    }

    public static void setMessages(ResourceBundle messages) {
        Messages.messages = new VariableResourceBundleWrapper(messages);
    }

    public static String formatString(@PropertyKey(resourceBundle="com.install4j.runtime.messages.messages") String key, Object ... arguments2) {
        return Messages.format(Messages.getString(key), arguments2);
    }

    public static String format(String pattern, Object ... arguments2) {
        pattern = StringUtil.replace(pattern, "'", "''");
        if (!InstallerVariables.isReplaceInstallerAndCompilerVariables()) {
            pattern = StringUtil.replace(pattern, "${installer:", "$'{'installer:");
            pattern = StringUtil.replace(pattern, "${compiler:", "$'{'compiler:");
            pattern = StringUtil.replace(pattern, "${form:", "$'{'form:");
        }
        pattern = StringUtil.replace(pattern, "''{''", "'{'");
        MessageFormat messageFormat = new MessageFormat(pattern = StringUtil.replace(pattern, "''}''", "'}'"));
        int argumentCount = messageFormat.getFormatsByArgumentIndex().length;
        String returnValue = argumentCount == 0 ? pattern : messageFormat.format(arguments2);
        if (!InstallerVariables.isReplaceInstallerAndCompilerVariables()) {
            returnValue = StringUtil.replace(returnValue, "'{'", "{");
        }
        return returnValue;
    }

    public static VariableResourceBundleWrapper createMessages(LanguageConfig languageConfig) {
        try {
            return Messages.createMessages(languageConfig, InstallerConfig.getCurrentInstance());
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = "Internal error: Could not open message file.";
            if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
                System.err.println(message);
            } else {
                JOptionPane.showMessageDialog(null, message, "install4j", 0, null);
            }
            InstallerUtil.exit(1);
            throw new RuntimeException();
        }
    }

    public static VariableResourceBundleWrapper createMessages(LanguageConfig languageConfig, InstallerConfig installerConfig) throws IOException {
        ResourceBundle messages;
        if (languageConfig == null && Messages.isResourceAvailable(MESSAGES_FILE_PATH)) {
            messages = Messages.createDevResourceBundle();
        } else {
            if (languageConfig == null) {
                languageConfig = Messages.detectLanguageConfig();
            }
            messages = Messages.createResourceBundle(languageConfig, installerConfig);
        }
        return new VariableResourceBundleWrapper(messages);
    }

    private static LanguageConfig detectLanguageConfig() throws IOException {
        Locale locale;
        String languageId;
        File configFile = InstallerUtil.getInstallerFile("i4jparams.conf");
        if (!configFile.exists() || !configFile.canRead()) {
            return null;
        }
        InstallerConfig config2 = InstallerConfig.getConfigFromFile(configFile);
        LanguageConfig languageConfig = config2.getLanguageById(languageId = (locale = Locale.getDefault()).getLanguage());
        if (languageConfig != null) {
            return languageConfig;
        }
        String languageAndCountryId = languageId + "_" + locale.getCountry();
        LanguageConfig languageAndCountryConfig = config2.getLanguageById(languageAndCountryId);
        if (languageAndCountryConfig != null) {
            return languageAndCountryConfig;
        }
        return null;
    }

    private static boolean isResourceAvailable(String resourcePath) {
        return ResourceHelper.class.getClassLoader().getResource(resourcePath) != null;
    }

    @NotNull
    protected static FileResourceBundle createDevResourceBundle() throws IOException {
        FileResourceBundle defaultResourceBundle = new FileResourceBundle(ResourceHelper.class.getClassLoader().getResourceAsStream(MESSAGES_FILE_PATH), null);
        FileResourceBundle localizedResourceBundle = Messages.getLocalizedDevResourceBundle(defaultResourceBundle);
        if (localizedResourceBundle != null) {
            return localizedResourceBundle;
        }
        return defaultResourceBundle;
    }

    private static FileResourceBundle getLocalizedDevResourceBundle(FileResourceBundle defaultResourceBundle) throws IOException {
        Locale locale = Locale.getDefault();
        FileResourceBundle countryBundle = Messages.getLocalizedDevResourceBundle(locale.getLanguage() + "_" + locale.getCountry(), defaultResourceBundle);
        if (countryBundle != null) {
            return countryBundle;
        }
        return Messages.getLocalizedDevResourceBundle(locale.getLanguage(), defaultResourceBundle);
    }

    private static FileResourceBundle getLocalizedDevResourceBundle(String localeName, FileResourceBundle defaultResourceBundle) throws IOException {
        String resourcePath = "com/install4j/runtime/messages/messages_" + localeName + ".utf8";
        if (!localeName.equals("en") && Messages.isResourceAvailable(resourcePath)) {
            InputStream inputStream = ResourceHelper.class.getClassLoader().getResourceAsStream(resourcePath);
            return new FileResourceBundle(inputStream, (ResourceBundle)defaultResourceBundle);
        }
        return null;
    }

    protected static ResourceBundle createResourceBundle(LanguageConfig languageConfig, InstallerConfig installerConfig) throws IOException {
        ResourceBundle messages;
        File defaultMessagesFile = InstallerUtil.getInstallerFile("MessagesDefault");
        if (!defaultMessagesFile.exists()) {
            defaultMessagesFile = InstallerUtil.getInstallerFile("messages/messages_en.utf8");
        }
        ResourceBundle defaultMessages = new FileResourceBundle(defaultMessagesFile, null);
        if (languageConfig == null) {
            messages = defaultMessages;
        } else {
            File messagesFile;
            if (installerConfig != null) {
                LanguageConfig principalLanguageConfig = installerConfig.getLanguages().get(0);
                defaultMessages = Messages.createResourceBundleWithCustomLocalization(principalLanguageConfig, defaultMessages);
            }
            messages = (messagesFile = InstallerUtil.getInstallerFile(languageConfig.getMessageFile())).exists() ? new FileResourceBundle(messagesFile, defaultMessages) : defaultMessages;
            messages = Messages.createResourceBundleWithCustomLocalization(languageConfig, messages);
        }
        return messages;
    }

    private static ResourceBundle createResourceBundleWithCustomLocalization(LanguageConfig languageConfig, ResourceBundle messages) throws IOException {
        File customLocalizationFile;
        String customLocalizationFileName = languageConfig.getCustomLocalizationFile();
        if (customLocalizationFileName.trim().length() > 0 && (customLocalizationFile = InstallerUtil.getInstallerFile(customLocalizationFileName)).exists()) {
            messages = customLocalizationFileName.toLowerCase(Locale.ENGLISH).endsWith("properties") ? DefaultPropertyResourceBundle.create(customLocalizationFile, messages) : new FileResourceBundle(customLocalizationFile, messages);
        }
        return messages;
    }

    public static List<LanguageConfig> sortLanguages(List<LanguageConfig> languages, ResourceBundle messages) {
        ArrayList<LanguageConfig> sortedList = new ArrayList<LanguageConfig>(languages);
        sortedList.sort((o1, o2) -> {
            String name1 = Messages.getLocalizedLanguageName(o1, messages);
            String name2 = Messages.getLocalizedLanguageName(o2, messages);
            return name1.compareTo(name2);
        });
        return sortedList;
    }

    public static String getLocalizedLanguageName(LanguageConfig languageConfig, ResourceBundle messages) {
        String localizedName = null;
        try {
            localizedName = messages.getString(LANGUAGES_MESSAGE_PREFIX + languageConfig.getId());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (localizedName != null) {
            return localizedName;
        }
        return languageConfig.getName();
    }

    static {
        Messages.usedKeys("languages.zh_CN", "languages.zh_TW", "languages.hr", "languages.cs", "languages.da", "languages.nl", "languages.en", "languages.fi", "languages.fr", "languages.de", "languages.el", "languages.hu", "languages.it", "languages.ja", "languages.ko", "languages.no", "languages.pl", "languages.pt", "languages.pt_BR", "languages.ru", "languages.es", "languages.sv", "languages.tr", "languages.ro");
        messages = null;
    }
}

