/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.ejt.internal.io.StreamConsumerThread;
import com.exe4j.runtime.WinLauncher;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.launcher.Launcher;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import javax.swing.SwingUtilities;

class LanguageSelector {
    LanguageSelector() {
    }

    static void initSystemAndDefaultLanguage() {
        String defaultLanguageId;
        String systemLanguageId = System.getProperty("install4j.systemLanguage");
        if (systemLanguageId == null || !systemLanguageId.matches("\\w\\w")) {
            systemLanguageId = System.getProperty("user.language");
            System.setProperty("install4j.systemLanguage", systemLanguageId);
        }
        if ((defaultLanguageId = System.getProperty("install4j.defaultLanguage")) != null && systemLanguageId.matches("\\w\\w|\\w\\w_\\w\\w")) {
            System.setProperty("user.language", defaultLanguageId);
            Locale.setDefault(new Locale(defaultLanguageId.substring(0, 2), defaultLanguageId.length() == 5 ? defaultLanguageId.substring(3, 5) : Locale.getDefault().getCountry()));
            System.setProperty("install4j.defaultLanguage", "");
        }
    }

    static void initLanguage(ContextImpl context2, ScreenExecutor screenExecutor) {
        ScriptProperty languageSelectionScript;
        String languageId = context2.getLanguageId();
        Application application2 = InstallerConfig.getCurrentApplication();
        if (application2 instanceof InstallerApplication && System.getProperty("install4j.language") == null && (languageSelectionScript = ((InstallerApplication)application2).getLanguageSelectionScript()) != null && !Objects.equals(languageSelectionScript.getValue(), "")) {
            try {
                languageId = (String)context2.runScript(languageSelectionScript, application2, languageId);
                if (InstallerConfig.getCurrentInstance().getLanguageById(languageId) == null) {
                    languageId = null;
                } else {
                    context2.setLanguageId(languageId);
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
            }
        }
        if (languageId != null) {
            Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(languageId));
        } else {
            languageId = LanguageSelector.queryLanguage(screenExecutor);
            if (languageId == null) {
                InstallerUtil.exit(1);
            } else {
                context2.setLanguageId(languageId);
                String installerFileName = System.getProperty("exe4j.moduleName");
                if (installerFileName == null || !new File(installerFileName).exists() || InstallerUtil.isMacOS() || Objects.equals(languageId, System.getProperty("user.language")) || context2.isConsole() || context2.isUnattended() || Boolean.getBoolean("install4j.noSecondaryProcess")) {
                    Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(languageId));
                } else {
                    String[] command2;
                    Logger.getImpl().switchToSecondaryProcess();
                    if (InstallerUtil.isWindows()) {
                        InstallerUtil.storeJreInfoForInstaller();
                        command2 = WinLauncher.appendOriginalArgs(new String[]{installerFileName, "__i4j_lang_restart", "-Duser.language=" + languageId, "-Dinstall4j.language=" + languageId, "-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage"), "-Dexe4j.unextractedPositionRestart=" + Integer.getInteger("exe4j.unextractedPosition", 0)});
                    } else {
                        command2 = Launcher.appendOriginalArgs(new String[]{"/bin/sh", installerFileName, "__i4j_lang_restart", "-Duser.language=" + languageId, "-Dinstall4j.language=" + languageId, "-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage")});
                    }
                    try {
                        Process process2 = new ProcessBuilder(command2).directory(new File(System.getProperty("user.dir"))).start();
                        StreamConsumerThread.consumeOutput(process2);
                        try {
                            System.exit(process2.waitFor());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(languageId));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryLanguage(ScreenExecutor screenExecutor) {
        ReturnToken wakeupToken = new ReturnToken();
        SwingUtilities.invokeLater(() -> screenExecutor.selectLanguage(wakeupToken));
        ReturnToken returnToken = wakeupToken;
        synchronized (returnToken) {
            while (!wakeupToken.isWokenUp()) {
                try {
                    wakeupToken.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return (String)wakeupToken.getReturnValue();
    }
}

