/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Element;

public class ComponentConfig
extends ComponentNodeConfig {
    private boolean includesAll;
    private boolean changeable;
    private boolean downloaded;
    private boolean initiallySelected;
    private List<String> locations = new ArrayList<String>();
    private List<String> dependencies = new ArrayList<String>();
    private Set<ComponentConfig> dependencyOrigins = new HashSet<ComponentConfig>();

    public static String getUninstallerFilename() {
        InstallerConfig config2 = InstallerConfig.getCurrentInstance();
        List<LauncherConfig> launchers = config2.getLaunchers();
        for (LauncherConfig launcherConfig : launchers) {
            if (!launcherConfig.isUninstaller()) continue;
            return launcherConfig.getFile();
        }
        return "";
    }

    public static boolean isIncludedInSelectedComponents(String fileName) {
        fileName = fileName.replace('\\', '/');
        InstallerConfig config2 = InstallerConfig.getCurrentInstance();
        if (Objects.equals(config2.getType(), "macos") && config2.getMacSpecificConfig().isSingleBundle()) {
            String appDir = config2.getMacSpecificConfig().getRuntimeDirParent().trim();
            if (fileName.startsWith(appDir)) {
                fileName = fileName.substring(appDir.length());
            } else {
                return true;
            }
        }
        if (fileName.startsWith(".install4j")) {
            return true;
        }
        String uninstallerFilename = ComponentConfig.getUninstallerFilename().trim();
        if (uninstallerFilename.length() > 0 && (fileName.equals(uninstallerFilename) || fileName.startsWith(uninstallerFilename + ".app"))) {
            return true;
        }
        List<ComponentConfig> components = config2.getComponents();
        if (components.size() == 0) {
            return true;
        }
        for (ComponentConfig componentConfig : components) {
            if (!componentConfig.isSelected()) continue;
            if (componentConfig.isIncludesAll()) {
                return true;
            }
            if (!ComponentConfig.isIncludedInComponent(fileName, componentConfig)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIncludedInComponent(String fileName, ComponentConfig componentConfig) {
        for (String location : componentConfig.getLocations()) {
            if (ComponentConfig.isInFileset(location, fileName)) {
                return true;
            }
            if (!ComponentConfig.isEqualOrContained(location, fileName) && (!InstallerUtil.isMacOS() || !ComponentConfig.isEqualOrContained(location + ".app", fileName))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualOrContained(String location, String fileName) {
        return Objects.equals(location, fileName) || fileName.startsWith(location + "/") || Objects.equals(location, ".") && !fileName.startsWith(".i4j_");
    }

    public static boolean isInFileset(String location, String fileName) {
        String fileFileSet;
        if (!location.startsWith(".i4j_fileset_")) {
            return false;
        }
        String locationFileSet = location.substring(".i4j_fileset_".length());
        if (fileName.startsWith(".i4j_external_")) {
            int rootEnd = fileName.indexOf(47);
            String root2 = fileName.substring(".i4j_external_".length(), rootEnd == -1 ? fileName.length() : rootEnd);
            fileFileSet = InstallerConfig.getCurrentInstance().getFilesetForRootId(root2);
        } else {
            fileFileSet = "";
        }
        return Objects.equals(locationFileSet, fileFileSet);
    }

    public ComponentConfig(ComponentNodeConfig parent2) {
        super(parent2);
    }

    public boolean isIncludesAll() {
        return this.includesAll;
    }

    @Override
    public boolean isSelected() {
        return super.isSelected() || this.dependencyOrigins.size() > 0;
    }

    public boolean isInitiallySelected() {
        return this.initiallySelected;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.notifyDependentComponents(InstallerConfig.getCurrentInstance());
    }

    public void notifyDependentComponents(InstallerConfig installerConfig) {
        for (String dependency : this.dependencies) {
            ComponentConfig dependentComponent = installerConfig.getComponentById(dependency);
            if (dependentComponent == null) continue;
            if (this.isSelected()) {
                dependentComponent.addDependencyOrigin(this, installerConfig);
                continue;
            }
            dependentComponent.removeDependencyOrigin(this, installerConfig);
        }
    }

    private void addDependencyOrigin(ComponentConfig dependencyOrigin, InstallerConfig installerConfig) {
        boolean oldSelected = this.isSelected();
        this.dependencyOrigins.add(dependencyOrigin);
        if (this.isSelected() != oldSelected) {
            this.fireSelectionChanged();
        }
        this.notifyDependentComponents(installerConfig);
    }

    private void removeDependencyOrigin(ComponentConfig dependencyOrigin, InstallerConfig installerConfig) {
        boolean oldSelected = this.isSelected();
        this.dependencyOrigins.remove(dependencyOrigin);
        if (this.isSelected() != oldSelected) {
            this.fireSelectionChanged();
        }
        this.notifyDependentComponents(installerConfig);
    }

    public boolean isMandatory() {
        return this.dependencyOrigins.size() > 0;
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void setChangeable(boolean changeable) {
        boolean oldChangeable = this.changeable;
        this.changeable = changeable;
        if (changeable != oldChangeable) {
            this.fireChangeableChanged();
        }
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.initiallySelected = this.isSelected();
        this.includesAll = ComponentConfig.readAttribute(element, "allIncluded", this.includesAll);
        this.changeable = ComponentConfig.readAttribute(element, "changeable", this.changeable);
        this.downloaded = ComponentConfig.readAttribute(element, "downloaded", this.downloaded);
        for (Element childElement : ComponentConfig.childElements(element)) {
            String elementName = childElement.getTagName();
            if (Objects.equals(elementName, "entry")) {
                String location = ComponentConfig.readAttribute(childElement, "location", "").replace('\\', '/');
                this.locations.add(location);
                continue;
            }
            if (!Objects.equals(elementName, "dependsOn")) continue;
            String id = ComponentConfig.readAttribute(childElement, "id", "");
            this.dependencies.add(id);
        }
    }

    public String toString() {
        return this.getName() + "[" + this.getId() + "]; Selected: " + this.isSelected();
    }
}

