/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.api.screens.UninstallerScreen;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.IdWrapperUninstallerContext;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UninstallerContextImpl
extends ContextImpl
implements UninstallerContext,
Serializable {
    private Map<String, UninstallerContext> idNamespaceToContext = new HashMap<String, UninstallerContext>();

    public UninstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        UninstallerContextImpl.preLoadLibraries();
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                return UninstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            @Override
            public void setVariable(Object value) {
            }
        });
    }

    public static void preLoadLibraries() {
        if (!Util.isWindows()) {
            try {
                UnixFileSystem.getFileInformation(new File(System.getProperty("java.home")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void applyToScreen(Screen screen, ScreenBeanConfig config2) {
        if (screen instanceof UninstallerScreen) {
            ((UninstallerScreen)screen).setUninstallerContext(this.getIdWrapperUninstallerContext(config2));
        }
    }

    @Override
    public Context getIdWrapperContext(AbstractBeanConfig config2) {
        return this.getIdWrapperUninstallerContext(config2);
    }

    @Override
    public File getAdditionalUserJarsDir() {
        return null;
    }

    private UninstallerContext getIdWrapperUninstallerContext(AbstractBeanConfig config2) {
        String idNamespace = config2.getIdNamespace();
        if (idNamespace.length() == 0) {
            return this;
        }
        UninstallerContext wrapperContext = this.idNamespaceToContext.get(idNamespace);
        if (wrapperContext == null) {
            wrapperContext = new IdWrapperUninstallerContext(this, idNamespace);
            this.idNamespaceToContext.put(idNamespace, wrapperContext);
        }
        return wrapperContext;
    }

    @Override
    public boolean performActionInt(ActionBeanConfig config2) throws UserCanceledException {
        UninstallerContext currentContext = this.getIdWrapperUninstallerContext(config2);
        return UninstallerContextImpl.performActionIntStatic(config2, currentContext);
    }

    @Override
    public void rollbackActionInt(ActionBeanConfig config2) {
    }

    @Override
    public boolean isUninstallForUpgrade() {
        return Boolean.getBoolean("install4j.upgradeUninstall");
    }

    @Override
    public void finish(int exitCode) {
        if (this.isUninstallForUpgrade()) {
            UninstallerContextImpl.setPropertyAll("install4j.noRebootDeletion", "true");
        } else if (Util.isWindows()) {
            MsiHelper.removeMsiUninstaller(this);
        }
        FileInstaller.getInstance().finishUninstall();
        super.finish(exitCode);
    }

    private static void setPropertyAll(final String name, final String value) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            @Override
            protected void run(Context context2) {
                System.setProperty(name, value);
            }
        });
    }

    @Override
    protected String getRebootMessage() {
        return Messages.getString(".UninstalledAndNeedsRestart");
    }

    @Override
    protected ExecutionContext getWinDelExecutionContext() {
        return ExecutionContext.MAXIMUM;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ContextStandin();
    }

    private static class ContextStandin
    implements Serializable {
        private ContextStandin() {
        }

        private Object readResolve() throws ObjectStreamException {
            return ContextImpl.getCurrentContext();
        }
    }
}

