/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.installer.Application;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.UninstallerWizardScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.UninstallerConsoleScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.UninstallerUnattendedScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class Uninstaller {
    private Uninstaller() {
    }

    public static void main(String[] args2) {
        if (!HelperCommunication.executeAsHelper(args2)) {
            try {
                InstallerUtil.setInProcess(false);
                Uninstaller.runInProcess(args2);
            }
            catch (Throwable t) {
                InstallerUtil.reportException(t);
                System.exit(1);
            }
        }
    }

    private static void runInProcess(String[] args2) {
        InstallerConfig.setCurrentApplicationId("uninstaller");
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(args2);
        ScreenExecutor screenExecutor = Uninstaller.getScreenExecutor(commandLineOptions);
        if (MsiHelper.isMsiStartMsiMatch() && !Boolean.getBoolean("install4j.allowNoMsi") && !Boolean.getBoolean("install4j.upgradeUninstall")) {
            Util.showErrorMessage(Messages.getString(".MsiUninstallerMismatch"));
            System.exit(1);
        }
        new Controller(screenExecutor, commandLineOptions).start();
    }

    private static ScreenExecutor getScreenExecutor(InstallerUtil.CommandLineOptions commandLineOptions) {
        ScreenExecutor screenExecutor;
        Application.initInstallationDirectory();
        ExecutionMode executionMode = InstallerUtil.getExecutionMode(commandLineOptions, true);
        if (executionMode == ExecutionMode.UNATTENDED || executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS) {
            InstallerUtil.setUnattended(true);
            screenExecutor = new UninstallerUnattendedScreenExecutor(commandLineOptions.quietOverwrite, commandLineOptions.noFileFailures, commandLineOptions.wait, InstallerUtil.getSplash(commandLineOptions, executionMode), InstallerUtil.isUnattendedAlerts(commandLineOptions, executionMode));
        } else if (executionMode == ExecutionMode.CONSOLE) {
            InstallerUtil.setConsole(true);
            screenExecutor = new UninstallerConsoleScreenExecutor();
        } else {
            ScreenExecutor[] screenExecutors = new ScreenExecutor[1];
            try {
                SwingUtilities.invokeAndWait(() -> {
                    screenExecutors[0] = new UninstallerWizardScreenExecutor();
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            screenExecutor = screenExecutors[0];
        }
        InstallerVariables.initCommandLine(commandLineOptions.varFileName, commandLineOptions.commandLineVars);
        return screenExecutor;
    }
}

