/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.launcher.integration.UpdateLog;
import com.install4j.runtime.launcher.util.SingleInstance;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Application {
    public static void main(String[] args2) {
        if (!HelperCommunication.executeAsHelper(args2)) {
            InstallerUtil.setInProcess(false);
            if (args2.length == 0) {
                System.err.println("Please provide the application id as first argument");
                System.exit(1);
            }
            String applicationId = args2[0];
            String[] rest = new String[args2.length - 1];
            System.arraycopy(args2, 1, rest, 0, args2.length - 1);
            InstallerConfig.setCurrentApplicationId(applicationId);
            CustomApplication customApplication = Application.getCustomApplication();
            if (customApplication != null && customApplication.isSingleInstance() && customApplication.isCreateExecutable()) {
                File exeFileName = System.getProperty("exe4j.moduleName") != null ? new File(System.getProperty("exe4j.moduleName")) : Application.getExeFile(customApplication);
                SingleInstance.checkForCurrentLauncher(exeFileName, false, null);
            }
            InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(rest);
            ProgressCommunication.init();
            Application.runApplication(commandLineOptions, false, null);
        }
    }

    public static synchronized void runApplicationInProcess(String applicationId, String[] arguments2, boolean dialog, Window parentWindow) {
        FileInstaller.clearFileInstaller();
        InstallerConfig.clearCurrentApplication();
        InstallerConfig.setCurrentApplicationId(applicationId);
        if (arguments2 == null) {
            arguments2 = new String[]{};
        }
        ArrayList<String> allArguments = new ArrayList<String>();
        StringUtil.splitupCommandLine(allArguments, InstallerConfig.getCurrentApplication().getArguments());
        allArguments.addAll(Arrays.asList(arguments2));
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(allArguments.toArray(new String[0]));
        Runnable runnable = () -> {
            try {
                Application.runApplication(commandLineOptions, dialog, parentWindow);
            }
            finally {
                UpdateLog.setUpdaterApplication(false);
            }
        };
        CustomApplication customApplication = Application.getCustomApplication();
        if (customApplication != null && customApplication.isSingleInstance() && customApplication.isCreateExecutable()) {
            if (!SingleInstance.checkInProcessAndRun(Application.getExeFile(customApplication), runnable)) {
                InstallerUtil.exit(0);
            }
        } else {
            runnable.run();
        }
    }

    private static void runApplication(InstallerUtil.CommandLineOptions commandLineOptions, boolean dialog, Window parentWindow) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(commandLineOptions, dialog, parentWindow);
            Application.initInstallationDirectory();
            new Controller(screenExecutor, commandLineOptions).start();
        }
        catch (Throwable t) {
            InstallerUtil.reportException(t);
            InstallerUtil.exit(1);
        }
    }

    static void initInstallationDirectory() {
        File installationDirectory;
        InstallerConfig config2 = InstallerConfig.getCurrentInstance();
        File runtimeDir = ResourceHelper.getRuntimeDir();
        if (Util.isMacOS() && config2.getMacSpecificConfig().isSingleBundle()) {
            File bundleDirectory = Application.makeCanonical(new File(runtimeDir, "../../../.."));
            config2.getMacSpecificConfig().setSingleBundleName(bundleDirectory.getName());
            installationDirectory = bundleDirectory.getParentFile();
        } else {
            installationDirectory = new File(runtimeDir, "..");
        }
        config2.setInstallationDirectory(Application.makeCanonical(installationDirectory));
    }

    @NotNull
    private static File makeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    @Nullable
    public static File getExeFile(ApplicationWithPath application2) {
        if (application2 instanceof CustomApplication && !((CustomApplication)application2).isCreateExecutable()) {
            return null;
        }
        File execDir = Application.getExecutableDir(application2);
        File execFile = new File(execDir, application2.getExecutableName() + (Util.isWindows() ? ".exe" : ""));
        try {
            return execFile.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return execFile;
        }
    }

    @Nullable
    private static File getExecutableDir(ApplicationWithPath application2) {
        File execDir = application2.getExecutableDirectory();
        if (execDir == null || execDir.getPath().trim().equals("")) {
            return ResourceHelper.getRuntimeDir();
        }
        return new File(ResourceHelper.getRuntimeDir(), "../" + execDir.getPath());
    }

    private static CustomApplication getCustomApplication() {
        com.install4j.runtime.beans.applications.Application application2 = InstallerConfig.getCurrentApplication();
        if (application2 instanceof CustomApplication) {
            return (CustomApplication)application2;
        }
        return null;
    }
}

