/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser.swingdirectory;

import com.install4j.api.UiUtil;
import com.install4j.runtime.filechooser.FileChooserWithLowerAccessory;
import com.install4j.runtime.filechooser.swingdirectory.JDirectoryChooserDialog;
import com.install4j.runtime.filechooser.swingdirectory.JDirectoryChooserUI;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;

public class JDirectoryChooser
extends FileChooserWithLowerAccessory {
    static final String PROPERTY_MANUAL_DIRECTORY_CHOOSER = "manualDirectoryChooser";
    static final String PROPERTY_LOWER_ACCESSORY = "lowerAccessory";
    private String title;
    private JDirectoryChooserDialog dialog;
    private int returnValue = -1;
    private boolean activated;
    private boolean allowFolderCreation;
    private String cancelButtonText;
    private JComponent lowerAccessory;

    public JDirectoryChooser() {
    }

    public JDirectoryChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public JDirectoryChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public JDirectoryChooser(FileSystemView fsv) {
        super(fsv);
    }

    public JDirectoryChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public JDirectoryChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public boolean isAllowFolderCreation() {
        return this.allowFolderCreation;
    }

    @Override
    public void setLowerAccessory(JComponent lowerAccessory) {
        this.firePropertyChange(PROPERTY_LOWER_ACCESSORY, this.lowerAccessory, lowerAccessory);
        this.lowerAccessory = lowerAccessory;
    }

    public JComponent getLowerAccessory() {
        return this.lowerAccessory;
    }

    public void setAllowFolderCreation(boolean allowFolderCreation) {
        this.allowFolderCreation = allowFolderCreation;
        this.updateUI();
    }

    public boolean isDialogVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    @Override
    public void setUI(ComponentUI ui) {
        if (!(ui instanceof JDirectoryChooserUI)) {
            this.setUI(new JDirectoryChooserUI(this));
        } else {
            super.setUI(ui);
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (dir != null && this.getSelectedFile() != null && !Objects.equals(dir, this.getSelectedFile())) {
            this.setSelectedFile(null);
        }
        super.setCurrentDirectory(dir);
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        super.setSelectedFiles(selectedFiles);
        this.setSelectedFile(selectedFiles[0]);
    }

    @Override
    public int showDialog(Component parent2, String approveButtonText) {
        return this.showDialog(parent2, approveButtonText, null);
    }

    public int showDialog(Component parent2, String approveButtonText, String cancelButtonText) {
        this.cancelButtonText = cancelButtonText;
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
        }
        if (this.dialog == null) {
            this.dialog = new JDirectoryChooserDialog(this, UiUtil.getParentWindow());
            this.dialog.setTitle(this.title);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!JDirectoryChooser.this.activated) {
                        ((JDirectoryChooserUI)JDirectoryChooser.this.getUI()).scrollToSelection();
                    }
                    JDirectoryChooser.this.activated = true;
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    JDirectoryChooser.this.returnValue = 1;
                }
            });
        }
        this.returnValue = -1;
        this.rescanCurrentDirectory();
        this.dialog.setVisible(true);
        return this.returnValue;
    }

    @Override
    protected void fireActionPerformed(String command2) {
        if (Objects.equals(command2, "ApproveSelection")) {
            this.returnValue = 0;
            this.dialog.setVisible(false);
        } else if (Objects.equals(command2, "CancelSelection")) {
            this.returnValue = 1;
            this.dialog.setVisible(false);
        }
        super.fireActionPerformed(command2);
    }

    public static void main(String[] args2) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty(PROPERTY_MANUAL_DIRECTORY_CHOOSER, "true");
        JDirectoryChooser chooser = new JDirectoryChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setAllowFolderCreation(true);
        chooser.setDialogTitle("Select directory");
        chooser.setCurrentDirectory(new File("c:\\Program Files (x86)"));
        int choice = chooser.showOpenDialog(null);
        if (choice == 1) {
            System.out.println("User Canceled");
        } else {
            System.out.println("Dialog Selection: " + chooser.getSelectedFile().getAbsolutePath());
        }
        System.exit(0);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setDialogTitle(String title) {
        this.setTitle(title);
        super.setDialogTitle(title);
    }

    public void focusTree() {
        ((JDirectoryChooserUI)this.getUI()).focusTree();
    }

    public String getCancelButtonText() {
        return this.cancelButtonText;
    }
}

