/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.runtime.filechooser.FileAccessMode;
import com.install4j.runtime.filechooser.FileChooser;
import com.install4j.runtime.filechooser.MultiFileFilter;
import com.install4j.runtime.filechooser.WindowsFileChooserHelper;
import com.install4j.runtime.installer.platform.win32.VistaFileChooser;
import com.install4j.runtime.util.SecondaryLoopHelper;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

class WindowsFileChooser
extends FileChooser {
    private Collection<File> selectedFiles;

    WindowsFileChooser() {
    }

    @Override
    public boolean selectInternal() {
        VistaFileChooser vistaFileChooser = new VistaFileChooser(this.getFileAccessMode() == FileAccessMode.SAVE).includedOptions(0x42 | (this.isMultiple() ? 512 : 0) | (this.isFileHidingEnabled() ? 0 : 0x10000000)).title(this.getTitle()).button(this.getApproveButtonText()).directory(this.getCurrentDirectory()).fileName(this.getDefaultSelectedFile() != null ? this.getDefaultSelectedFile().getName() : null);
        VistaFileChooser.Question[] questions = WindowsFileChooserHelper.configureQuestions(vistaFileChooser, this);
        this.fillFilter(vistaFileChooser);
        File[] result2 = WindowsFileChooser.showFileChooser(vistaFileChooser, this.getParent());
        WindowsFileChooserHelper.saveQuestions(questions, this);
        if (result2 != null && result2.length > 0) {
            this.selectedFiles = Arrays.asList(result2);
            return true;
        }
        this.selectedFiles = Collections.emptyList();
        return false;
    }

    private void fillFilter(VistaFileChooser vistaFileChooser) {
        if (!this.getFileFilters().isEmpty()) {
            VistaFileChooser.Filter[] filter2 = new VistaFileChooser.Filter[this.getFileFilters().size()];
            int arrayPos = 0;
            int selectedPos = 0;
            for (MultiFileFilter fileFilter : this.getFileFilters()) {
                if (fileFilter.equals(this.getSelectedFileFilter())) {
                    selectedPos = arrayPos;
                }
                StringBuilder spec = new StringBuilder();
                for (String suffix : fileFilter.getSuffixes()) {
                    if (spec.length() > 0) {
                        spec.append(';');
                    }
                    if (!fileFilter.isExact()) {
                        spec.append("*");
                    }
                    spec.append(suffix);
                }
                filter2[arrayPos++] = new VistaFileChooser.Filter(fileFilter.getDescription(), spec.toString());
            }
            vistaFileChooser.filter(filter2).selectedFilter(selectedPos);
        }
    }

    @Override
    protected Collection<File> getSelectedFilesInternal() {
        return this.selectedFiles;
    }

    static File[] showFileChooser(VistaFileChooser vistaFileChooser, Window parent2) {
        return SecondaryLoopHelper.executeWithSecondaryLoop(() -> vistaFileChooser.show(parent2));
    }
}

