/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.runtime.filechooser.FileChooser;
import com.install4j.runtime.filechooser.MacosFileChooserHelper;
import com.install4j.runtime.filechooser.MultiFileFilter;
import com.install4j.runtime.installer.platform.macos.MacosUiHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class MacosFileChooser
extends FileChooser {
    private MacosUiHelper.Result result;

    MacosFileChooser() {
    }

    @Override
    protected Collection<File> getSelectedFilesInternal() {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : this.result.getSelectedPaths()) {
            files.add(new File(path));
        }
        return files;
    }

    @Override
    public boolean selectInternal() {
        this.result = MacosUiHelper.showFileChooser(this.getDialogType(), this.getTitle(), MacosFileChooserHelper.getCurrentDirectoryWithSelection(this), this.getApproveButtonText(), MacosFileChooserHelper.getDefaultSelectedFileName(this), !this.isFileHidingEnabled(), this.getSuffixes(), this.getDescriptions(), this.getSelectedFileFilterIndex(), this.getExactNames(), MacosFileChooserHelper.getQuestions(this), MacosFileChooserHelper.getQuestionPresets(this));
        MacosFileChooserHelper.saveQuestions(this.result, this);
        return this.result.getSelectedPaths().length > 0;
    }

    private int getDialogType() {
        switch (this.getFileAccessMode()) {
            case OPEN: {
                return this.isMultiple() ? 2 : 1;
            }
            case SAVE: {
                return 3;
            }
        }
        throw new RuntimeException("unknown file access type " + this.getFileAccessMode().name());
    }

    private String[][] getSuffixes() {
        List<MultiFileFilter> fileFilters = this.getFileFilters();
        String[][] suffixes = new String[fileFilters.size()][];
        int index2 = 0;
        for (MultiFileFilter fileFilter : fileFilters) {
            String[] singleSuffixes = fileFilter.getSuffixes();
            String[] plainSuffixes = new String[singleSuffixes.length];
            for (int i = 0; i < singleSuffixes.length; ++i) {
                String suffix = singleSuffixes[i];
                if (suffix.startsWith(".")) {
                    suffix = suffix.substring(1);
                } else if (suffix.startsWith("*.")) {
                    suffix = suffix.substring(2);
                }
                plainSuffixes[i] = suffix;
            }
            suffixes[index2++] = plainSuffixes;
        }
        return suffixes;
    }

    private String[] getDescriptions() {
        List<MultiFileFilter> fileFilters = this.getFileFilters();
        String[] descriptions = new String[fileFilters.size()];
        int index2 = 0;
        for (MultiFileFilter fileFilter : fileFilters) {
            descriptions[index2++] = fileFilter.getName();
        }
        return descriptions;
    }

    private int getSelectedFileFilterIndex() {
        if (this.getSelectedFileFilter() != null) {
            return this.getFileFilters().indexOf(this.getSelectedFileFilter());
        }
        return 0;
    }

    private boolean[] getExactNames() {
        List<MultiFileFilter> fileFilters = this.getFileFilters();
        boolean[] exactNames = new boolean[fileFilters.size()];
        int index2 = 0;
        for (MultiFileFilter fileFilter : fileFilters) {
            exactNames[index2++] = fileFilter.isExact();
        }
        return exactNames;
    }
}

