/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.installationcomponents;

import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentNode;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class InstallationComponentTreeModel
extends ComponentTreeModel {
    public InstallationComponentTreeModel(ComponentTree tree) {
        super(tree);
        InstallerConfig config2 = InstallerConfig.getCurrentInstance();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.root;
        if (config2 != null) {
            this.addFolder(rootNode, config2.getComponentRoot());
        } else {
            this.addDemoNode(rootNode, 1);
            this.addDemoNode(rootNode, 2);
            this.addDemoNode(rootNode, 3);
            this.addFolder(rootNode, new ComponentFolderConfig(null));
        }
    }

    public void addDemoNode(DefaultMutableTreeNode rootNode, int index2) {
        ComponentConfig componentConfig = new ComponentConfig(null);
        componentConfig.setName("Installation component " + index2);
        componentConfig.setDescription("This is the description for installation component " + index2);
        componentConfig.setChangeable(true);
        componentConfig.setHideHelpButton(false);
        rootNode.add(new InstallationComponentNode(componentConfig, this));
    }

    public void checkFolders() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.root;
        Enumeration<TreeNode> en = rootNode.depthFirstEnumeration();
        ArrayList<ComponentNode> nodesToHide = new ArrayList<ComponentNode>();
        while (en.hasMoreElements()) {
            ComponentNode node2 = (ComponentNode)en.nextElement();
            if (node2.getComponentNodeConfig() == null) continue;
            if (node2.getComponentNodeConfig().isHidden()) {
                nodesToHide.add(node2);
                continue;
            }
            if (!(node2 instanceof ComponentFolderNode)) continue;
            ComponentFolderNode componentFolderNode = (ComponentFolderNode)node2;
            ComponentFolderConfig componentFolderConfig = componentFolderNode.getComponentFolderConfig();
            if (componentFolderConfig.isExpanded()) {
                this.getTree().expandPath(new TreePath(node2.getPath()));
            }
            componentFolderNode.checkState();
        }
        for (ComponentNode node3 : nodesToHide) {
            ((ComponentFolderNode)node3.getParent()).hide(node3);
        }
    }

    private void addFolder(DefaultMutableTreeNode parentNode, ComponentFolderConfig folderConfig) {
        for (ComponentNodeConfig componentNodeConfig : folderConfig.getComponents()) {
            ComponentNode childNode = null;
            if (componentNodeConfig instanceof ComponentFolderConfig) {
                ComponentFolderConfig childFolderConfig = (ComponentFolderConfig)componentNodeConfig;
                childNode = new ComponentFolderNode(childFolderConfig, (ComponentTreeModel)this);
                this.addFolder(childNode, childFolderConfig);
            } else if (componentNodeConfig instanceof ComponentConfig) {
                childNode = new InstallationComponentNode((ComponentConfig)componentNodeConfig, this);
            }
            if (childNode == null) continue;
            parentNode.add(childNode);
        }
    }
}

