/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentNode
extends DefaultMutableTreeNode
implements ComponentNodeConfig.ComponentChangeListener {
    private ComponentNodeConfig config;
    private ComponentTreeModel model;
    private boolean inUserSelectionChange;

    public ComponentNode(ComponentNodeConfig config2, ComponentTreeModel model) {
        this.model = model;
        this.config = config2;
        if (config2 != null) {
            config2.addComponentChangeListener(this);
        }
    }

    @Override
    public void selectionChanged(ComponentNodeConfig componentNodeConfig) {
        this.model.getTree().selectionChanged(this, !this.inUserSelectionChange);
        this.redrawNodeAndParents();
    }

    @Override
    public void changeableChanged(ComponentNodeConfig componentNodeConfig) {
        this.redrawNodeAndParents();
    }

    public void setModel(ComponentTreeModel model) {
        this.model = model;
    }

    @Override
    public void hiddenChanged(ComponentNodeConfig componentNodeConfig) {
        ComponentFolderNode parentNode = (ComponentFolderNode)this.getParent();
        if (parentNode != null) {
            if (componentNodeConfig.isHidden()) {
                parentNode.hide(this);
            } else {
                parentNode.show(this);
            }
            parentNode.checkState();
        }
    }

    private void redrawNodeAndParents() {
        this.changed();
        ComponentFolderNode parentNode = (ComponentFolderNode)this.getParent();
        if (parentNode != null) {
            parentNode.checkState();
        }
    }

    public ComponentNodeConfig getComponentNodeConfig() {
        return this.config;
    }

    public boolean isSelected() {
        return this.config.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(boolean selected, boolean directUserAction) {
        if (!this.isChangeable()) {
            return;
        }
        this.inUserSelectionChange = directUserAction;
        try {
            this.config.setSelected(selected);
            this.changed();
            if (this.children != null) {
                this.setChildrenSelected(selected);
                if (!selected && this.getSelectedChildrenCount() > 0) {
                    int newCount;
                    int oldCount = 0;
                    while (oldCount != (newCount = this.getSelectedChildrenCount())) {
                        this.setChildrenSelected(false);
                        oldCount = newCount;
                    }
                }
            }
            Enumeration<TreeNode> en = ((DefaultMutableTreeNode)this.model.getRoot()).depthFirstEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)en.nextElement();
                if (!node2.isLeaf()) continue;
                ((ComponentFolderNode)node2.getParent()).checkState();
            }
        }
        finally {
            this.inUserSelectionChange = false;
        }
    }

    private int getSelectedChildrenCount() {
        int count2 = 0;
        for (Object child2 : this.children) {
            ComponentNode node2 = (ComponentNode)child2;
            if (!node2.isSelected()) continue;
            ++count2;
        }
        return count2;
    }

    private void setChildrenSelected(boolean selected) {
        for (Object child2 : this.children) {
            ComponentNode node2 = (ComponentNode)child2;
            node2.setSelected(selected, false);
        }
    }

    protected void changed() {
        if (this.model != null) {
            this.model.nodeChanged(this);
        }
    }

    protected boolean isChangeable() {
        return true;
    }

    public void setDisplayDescription(boolean displayDescription) {
        if (this.config == null) {
            return;
        }
        this.config.setDisplayDescription(displayDescription);
        ComponentTree tree = this.model.getTree();
        tree.setEditable(true);
        tree.startEditingAtPath(new TreePath(this.getPath()));
        tree.stopEditing();
        tree.setEditable(false);
        this.changed();
    }

    public void toggleDisplayDescription() {
        this.setDisplayDescription(!this.config.isDisplayDescription());
    }

    protected ComponentTreeModel getModel() {
        return this.model;
    }
}

