/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.groups;

import com.install4j.api.Util;
import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.GroupType;
import com.install4j.runtime.beans.groups.GroupOrientation;
import com.install4j.runtime.beans.groups.LayoutManagerGroup;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.IconHelper;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabGroup
extends LayoutManagerGroup {
    private static final Object TAB_ICON = "tabIcon";
    private String title = "";
    private ExternalFile iconFile;
    private ScriptProperty activationScript;
    private String tooltipText = "";
    private JTabbedPane tabbedPane;
    private JComponent tabComponent;
    private int lastIndex = -1;

    public String getTitle() {
        return TabGroup.replaceVariables(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ExternalFile getIconFile() {
        return this.replaceWithTextOverride("iconFile", this.iconFile, ExternalFile.class);
    }

    public void setIconFile(ExternalFile iconFile) {
        this.iconFile = iconFile;
    }

    public ScriptProperty getActivationScript() {
        return this.replaceWithTextOverride("activationScript", this.activationScript, ScriptProperty.class);
    }

    public void setActivationScript(ScriptProperty activationScript) {
        this.activationScript = activationScript;
    }

    public String getTooltipText() {
        return TabGroup.replaceVariables(this.tooltipText);
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.insertTab(this.lastIndex);
            this.setEnabled(this.isEnabled());
        } else {
            int index2 = this.tabbedPane.indexOfComponent(this.tabComponent);
            if (index2 >= 0) {
                this.lastIndex = index2;
                this.tabbedPane.removeTabAt(index2);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int index2 = this.tabbedPane.indexOfComponent(this.tabComponent);
        if (index2 >= 0) {
            this.tabbedPane.setEnabledAt(index2, enabled);
        }
    }

    @Override
    protected int getDefaultCellSpacing() {
        return 0;
    }

    @Override
    public GroupOrientation getGroupOrientation() {
        return GroupOrientation.VERTICAL;
    }

    @Override
    public GroupType getGroupType() {
        return GroupType.SINGLE_TAB;
    }

    @Override
    public Anchor getDefaultAnchor() {
        return Anchor.NORTHWEST;
    }

    @Override
    public JComponent createComponent(JComponent container2) {
        this.tabComponent = super.createComponent(container2);
        if (this.getIconFile() != null) {
            IconHelper.withIcon(this.getIconFile(), this.getContext(), icon -> {
                this.tabComponent.putClientProperty(TAB_ICON, icon);
                return null;
            });
        }
        this.tabbedPane = (JTabbedPane)container2;
        this.insertTab(-1);
        this.tabbedPane.addChangeListener(event -> {
            if (this.getActivationScript() != null && this.tabbedPane.getSelectedComponent() == this.tabComponent) {
                try {
                    this.getContext().runScript(this.getActivationScript(), this, this.getFormEnvironment().getLayoutGroupById(this.getId()), this.getFormEnvironment());
                }
                catch (Exception e) {
                    Util.printAnnotatedStackTrace(e);
                    Logger.getInstance().log(e);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        return panel;
    }

    private void insertTab(int index2) {
        if (this.isVisible()) {
            int componentCount = this.tabbedPane.getComponentCount();
            int actualIndex = index2 < 0 ? componentCount : Math.min(index2, componentCount);
            String titleWithoutMnemonics = AbstractFormComponent.getTextWithoutMnemonics(this.getTitle());
            this.tabbedPane.insertTab(titleWithoutMnemonics, (Icon)this.tabComponent.getClientProperty(TAB_ICON), this.tabComponent, this.getTooltipText().length() > 0 ? this.getTooltipText() : null, actualIndex);
            int mnemonicCharIndex = AbstractFormComponent.getMnemonicCharIndex(this.getTitle());
            if (mnemonicCharIndex >= 0) {
                int mnemonic = titleWithoutMnemonics.charAt(mnemonicCharIndex);
                if (mnemonic >= 97 && mnemonic <= 122) {
                    mnemonic -= 32;
                }
                this.tabbedPane.setMnemonicAt(actualIndex, mnemonic);
                this.tabbedPane.setDisplayedMnemonicIndexAt(actualIndex, mnemonicCharIndex);
            }
        }
    }

    @Override
    protected Insets getDefaultInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void makeTabVisible() {
        this.tabbedPane.setSelectedComponent(this.tabComponent);
    }
}

