/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.beans.formcomponents.UpdateAlertSelection;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.ToolTipHelpLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UpdateAlertComponent
extends SystemFormComponent {
    public static final String FORM_VARIABLE_WELCOME_MESSAGE = "welcomeMessage";
    private boolean updateCheck = true;
    private UpdateAlertSelection updateAlertSelection = UpdateAlertSelection.EXISTING;
    private ScriptProperty selectionScript;
    private JRadioButton rdoInstallUpdate;
    private JRadioButton rdoInstallNew;
    private ButtonGroup bgrInstall;
    private ToolTipHelpLabel helpLabel;

    public boolean isUpdateCheck() {
        return this.replaceWithTextOverride("updateCheck", this.updateCheck);
    }

    public void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    public UpdateAlertSelection getUpdateAlertSelection() {
        return this.replaceWithTextOverride("updateAlertSelection", this.updateAlertSelection, UpdateAlertSelection.class);
    }

    public void setUpdateAlertSelection(UpdateAlertSelection updateAlertSelection) {
        this.updateAlertSelection = updateAlertSelection;
    }

    public ScriptProperty getSelectionScript() {
        return this.replaceWithTextOverride("selectionScript", this.selectionScript, ScriptProperty.class);
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public JComponent createCenterComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.anchor = 23;
        gc.fill = 2;
        gc.weightx = 1.0;
        DisplayTextArea dtxa = new DisplayTextArea();
        Context context2 = this.getContext();
        dtxa.setText("\n" + context2.getMessage(".PreviousInstallationLabel"));
        panel.add((Component)dtxa, gc);
        gc.fill = 0;
        ++gc.gridy;
        ItemListener listener = e -> {
            if (e.getStateChange() == 1) {
                this.executeSelectionScript();
            }
        };
        this.rdoInstallUpdate = new JRadioButton(context2.getMessage(".RadioUpdateInstallation"));
        this.rdoInstallUpdate.setOpaque(false);
        this.rdoInstallNew = new JRadioButton(context2.getMessage(".RadioNewInstallation"));
        this.rdoInstallNew.setOpaque(false);
        this.rdoInstallNew.addItemListener(listener);
        if (this.getUpdateAlertSelection() == UpdateAlertSelection.DIFFERENT) {
            this.rdoInstallNew.setSelected(true);
        } else {
            this.rdoInstallUpdate.setSelected(true);
        }
        this.rdoInstallUpdate.addItemListener(listener);
        this.bgrInstall = new ButtonGroup();
        this.bgrInstall.add(this.rdoInstallUpdate);
        this.bgrInstall.add(this.rdoInstallNew);
        this.helpLabel = new ToolTipHelpLabel("");
        gc.fill = 0;
        gc.insets.top = 5;
        Box box = new Box(2);
        box.add(this.rdoInstallUpdate);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.helpLabel);
        panel.add((Component)box, gc);
        gc.insets.top = 0;
        ++gc.gridy;
        panel.add((Component)this.rdoInstallNew, gc);
        ++gc.gridy;
        return panel;
    }

    public void update() {
        this.helpLabel.setToolTipText(this.getContext().getInstallationDirectory().getPath());
    }

    public boolean isUpdate() {
        return this.rdoInstallUpdate.isSelected();
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        Context context2 = this.getContext();
        if (this.getFormEnvironment().isDesignTime()) {
            this.setVisible(true);
        } else if (this.isUpdateCheck() && this.isUpdateInstallation()) {
            this.update();
            boolean writableInstallationDirectory = InstallerUtil.checkWritableInstallationDirectory(context2.getInstallationDirectory(), false);
            this.setVisible(writableInstallationDirectory);
        } else {
            this.setVisible(false);
        }
        this.getFormEnvironment().setFormVariable(FORM_VARIABLE_WELCOME_MESSAGE, Messages.format(UpdateAlertComponent.replaceVariables(context2.getMessage(this.isVisible() ? ".ConsoleWelcomeLabel" : ".WelcomeLabel3")), context2.getApplicationName()));
    }

    @Override
    public void formActivated() {
        super.formActivated();
        if (this.isVisible()) {
            this.executeSelectionScript();
        }
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.getSelectionScript(), this, this.rdoInstallUpdate.isSelected());
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    private boolean isUpdateInstallation() {
        Context context2 = this.getContext();
        return context2 instanceof InstallerContext && ((InstallerContext)context2).isUpdateInstallation();
    }

    @Override
    public boolean checkCompleted() {
        if (!this.getContext().isUnattended() && !this.getContext().isConsole() && this.isVisible()) {
            this.getContext().setVariable("sys.confirmedUpdateInstallation", this.isUpdate());
        }
        return super.checkCompleted();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (this.isUpdateCheck() && this.isUpdateInstallation()) {
            Context context2 = this.getContext();
            String previousLocationText = "";
            if (CompilerVariableHelper.getCompilerExtensionVariable(this.getContext(), "consoleShowPreviousInstallation", false)) {
                previousLocationText = "\n(" + this.getContext().getInstallationDirectory().getPath() + ")";
            }
            int result2 = console.askOption(context2.getMessage(".PreviousInstallationLabel") + previousLocationText, new String[]{context2.getMessage(".RadioUpdateInstallation"), context2.getMessage(".RadioNewInstallation")}, null, this.getUpdateAlertSelection() == UpdateAlertSelection.DIFFERENT ? 1 : 0, false, true);
            context2.setVariable("sys.confirmedUpdateInstallation", result2 == 0);
        }
        return true;
    }
}

