/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.WizardContext;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputVerifier;
import javax.swing.JComponent;

public class TextComponentUtil {
    public static void addInputVerifier(final AbstractFormComponent formComponent, final ScriptProperty inputVerifier, JComponent component, final InputVerifierParameterProvider parameterProvider) {
        if (inputVerifier != null) {
            component.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    try {
                        Boolean result2 = (Boolean)formComponent.getContext().runScript(inputVerifier, formComponent, parameterProvider.createInputVerifierParameters());
                        if (result2 != null && !result2.booleanValue()) {
                            TextComponentUtil.disarmAllButtons(formComponent);
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return true;
                }
            });
        }
    }

    private static void disarmAllButtons(AbstractFormComponent formComponent) {
        FormComponent[] formComponents;
        WizardContext wizardContext = formComponent.getContext().getWizardContext();
        if (wizardContext instanceof WizardScreenExecutor) {
            ((WizardScreenExecutor)wizardContext).disarmButtons();
        }
        for (FormComponent component : formComponents = formComponent.getFormEnvironment().getFormComponents()) {
            Object configurationObject;
            if (component.getConfigurationObjectClass() == null || !((configurationObject = component.getConfigurationObject()) instanceof AbstractButton)) continue;
            ButtonModel model = ((AbstractButton)configurationObject).getModel();
            model.setArmed(false);
            model.setPressed(false);
        }
    }

    public static interface InputVerifierParameterProvider {
        public Object[] createInputVerifierParameters();
    }
}

