/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.runtime.beans.formcomponents.AbstractTextAreaComponent;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class FileEditorComponent
extends AbstractTextAreaComponent {
    private File file;
    private String encoding = "";

    public File getFile() {
        return this.replaceWithTextOverride("file", FileEditorComponent.replaceVariables(this.file), File.class);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getEncoding() {
        return FileEditorComponent.replaceVariables(FileEditorComponent.replaceVariables(this.encoding));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    protected void initText(JTextComponent textComponent) {
        File usedFile = this.getUsedFile();
        if (usedFile.exists()) {
            try {
                Logger.getInstance().info(this, "Reading file " + this.getUsedFile());
                String text2 = InstallerUtil.readTextFile(usedFile, this.getEncoding());
                textComponent.setText(text2);
                textComponent.setCaretPosition(0);
            }
            catch (IOException e) {
                e.printStackTrace();
                Util.showErrorMessage(this.getContext().getMessage(".FileReadError", usedFile.getPath(), e.getMessage()));
            }
        } else {
            super.initText(textComponent);
        }
    }

    @Override
    public boolean checkCompleted() {
        if (!super.checkCompleted()) {
            return false;
        }
        File usedFile = this.getUsedFile();
        try {
            Logger.getInstance().info(this, "Writing file " + this.getUsedFile());
            InstallerUtil.writeTextFile(this.getTextValue(), usedFile, this.getEncoding(), false);
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            Util.showErrorMessage(this.getContext().getMessage(".FileWriteError", usedFile.getPath(), e.getMessage()));
            return false;
        }
    }

    @Override
    protected JTextComponent createTextComponent() {
        JTextArea textArea = (JTextArea)super.createTextComponent();
        textArea.setLineWrap(false);
        return textArea;
    }

    private File getUsedFile() {
        return this.getContext().getDestinationFile(this.getFile());
    }
}

