/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallationComponentSetup;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.InstallationDirectoryChooserComponent;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.DescriptionModeProvider;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentTree;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class ComponentSelectorComponent
extends SystemFormComponent
implements DescriptionModeProvider {
    private ScriptProperty selectionChangedScript;
    private boolean boldDescription = false;
    private boolean italicDescription = false;
    private boolean smallerDescription = false;
    private boolean fillVertical;
    private InstallationComponentTree tree;
    private JScrollPane scpTree;

    public ComponentSelectorComponent() {
        this.setBoldDescription(true);
    }

    public ScriptProperty getSelectionChangedScript() {
        return this.replaceWithTextOverride("selectionChangedScript", this.selectionChangedScript, ScriptProperty.class);
    }

    public void setSelectionChangedScript(ScriptProperty selectionChangedScript) {
        this.selectionChangedScript = selectionChangedScript;
    }

    @Override
    public boolean isBoldDescription() {
        return this.replaceWithTextOverride("boldDescription", this.boldDescription);
    }

    public void setBoldDescription(boolean boldDescription) {
        this.boldDescription = boldDescription;
    }

    @Override
    public boolean isItalicDescription() {
        return this.replaceWithTextOverride("italicDescription", this.italicDescription);
    }

    public void setItalicDescription(boolean italicDescription) {
        this.italicDescription = italicDescription;
    }

    @Override
    public boolean isSmallerDescription() {
        return this.replaceWithTextOverride("smallerDescription", this.smallerDescription);
    }

    public void setSmallerDescription(boolean smallerDescription) {
        this.smallerDescription = smallerDescription;
    }

    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    @Override
    public void formActivated() {
        this.tree.updateAllNodes();
        this.tree.checkFolders();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        console.println(this.getMessage(".SelectComponentsDesc"));
        ComponentFolderConfig componentRoot = InstallerConfig.getCurrentInstance().getComponentRoot();
        ComponentConsoleState componentConsoleState = new ComponentConsoleState();
        this.printFolder(console, componentRoot, componentConsoleState, "");
        while (true) {
            if (!componentConsoleState.helpIndexToComponentNodeConfig.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (Integer index2 : componentConsoleState.helpIndexToComponentNodeConfig.keySet()) {
                    if (buffer.length() > 0) {
                        buffer.append(", ");
                    }
                    buffer.append("*");
                    buffer.append(index2);
                }
                console.println(Messages.format(this.getMessage(".ConsoleComponentHelpLabel"), buffer.toString()));
            }
            String answer = console.askString(this.getMessage(".ConsoleMultipleSelectionLabel"), componentConsoleState.defaultConsoleSelection);
            try {
                if (answer.startsWith("*")) {
                    ComponentNodeConfig config2 = this.getConfigForIndex(answer.substring(1), componentConsoleState.helpIndexToComponentNodeConfig);
                    console.println();
                    console.println(config2.getName() + ": " + config2.getDescription());
                    console.println();
                    continue;
                }
                if (Objects.equals(answer, "\"\"")) {
                    answer = "";
                }
                HashSet<ComponentNodeConfig> selectedComponents = new HashSet<ComponentNodeConfig>();
                StringTokenizer stringTokenizer = new StringTokenizer(answer, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String token2 = stringTokenizer.nextToken().trim();
                    if (Objects.equals(token2.toLowerCase(Locale.ENGLISH), "x")) continue;
                    ComponentNodeConfig config3 = this.getConfigForIndex(token2, componentConsoleState.indexToComponentNodeConfig);
                    selectedComponents.add(config3);
                }
                selectedComponents.addAll(componentConsoleState.mandatoryComponents);
                componentRoot.setSelected(false);
                this.updateTree(selectedComponents, componentRoot);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private String getMessage(String messageKey) {
        return this.getContext().getMessage(messageKey);
    }

    private ComponentNodeConfig getConfigForIndex(String numberString, Map<Integer, ComponentNodeConfig> indexToComponentNodeConfig) throws NumberFormatException {
        int number = Integer.parseInt(numberString);
        ComponentNodeConfig config2 = indexToComponentNodeConfig.get(number);
        if (config2 == null) {
            throw new NumberFormatException("not available");
        }
        return config2;
    }

    private void updateTree(Set<ComponentNodeConfig> selectedComponents, ComponentFolderConfig folderConfig) {
        folderConfig.setBlockStateChanges(true);
        for (int i = 0; i < folderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig childConfig;
            childConfig.setSelected(selectedComponents.contains(childConfig = folderConfig.getComponents().get(i)) || folderConfig.isIncluded());
            if (!(childConfig instanceof ComponentFolderConfig)) continue;
            this.updateTree(selectedComponents, (ComponentFolderConfig)childConfig);
        }
    }

    private void printFolder(Console console, ComponentFolderConfig folderConfig, ComponentConsoleState componentConsoleState, String prefix) {
        for (int i = 0; i < folderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig childConfig = folderConfig.getComponents().get(i);
            this.printNode(componentConsoleState, childConfig, console, prefix);
            if (!(childConfig instanceof ComponentFolderConfig)) continue;
            this.printFolder(console, (ComponentFolderConfig)childConfig, componentConsoleState, prefix + "      ");
        }
    }

    private void printNode(ComponentConsoleState componentConsoleState, ComponentNodeConfig nodeConfig, Console console, String prefix) {
        boolean unchangeableNode;
        if (nodeConfig.isHidden()) {
            if (nodeConfig.isSelected()) {
                componentConsoleState.mandatoryComponents.add(nodeConfig);
            }
            return;
        }
        boolean bl = unchangeableNode = nodeConfig instanceof ComponentConfig && !((ComponentConfig)nodeConfig).isChangeable();
        if (!unchangeableNode || nodeConfig.isSelected()) {
            console.print(prefix + (unchangeableNode ? "X" : String.valueOf(componentConsoleState.index)) + ": " + nodeConfig.getName());
            if (!nodeConfig.getDescription().isEmpty()) {
                console.print(" [*" + componentConsoleState.index + "]");
                componentConsoleState.helpIndexToComponentNodeConfig.put(componentConsoleState.index, nodeConfig);
            }
            console.println();
            if (nodeConfig instanceof ComponentFolderConfig) {
                nodeConfig.setSelected(false);
            }
            if (unchangeableNode) {
                componentConsoleState.mandatoryComponents.add(nodeConfig);
            } else {
                if (nodeConfig.isSelected()) {
                    componentConsoleState.defaultConsoleSelection = componentConsoleState.defaultConsoleSelection == null ? "" : componentConsoleState.defaultConsoleSelection + ",";
                    componentConsoleState.defaultConsoleSelection = componentConsoleState.defaultConsoleSelection + componentConsoleState.index;
                }
                componentConsoleState.indexToComponentNodeConfig.put(componentConsoleState.index, nodeConfig);
            }
            ++componentConsoleState.index;
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.tree = new InstallationComponentTree(this);
        this.scpTree = new JScrollPane(this.tree);
        return this.scpTree;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.isFillVertical();
    }

    public void nodeToggled() {
        InstallationDirectoryChooserComponent installationDirectoryChooserComponent = this.getFormEnvironment().getFirstFormComponent(InstallationDirectoryChooserComponent.class);
        if (installationDirectoryChooserComponent != null) {
            installationDirectoryChooserComponent.update();
        }
    }

    public void selectionChanged(ComponentNode componentNode, boolean dependency) {
        ComponentNodeConfig componentNodeConfig = componentNode.getComponentNodeConfig();
        if (componentNodeConfig instanceof ComponentConfig) {
            ComponentConfig componentConfig = (ComponentConfig)componentNodeConfig;
            Context context2 = this.getContext();
            InstallationComponentSetup installationComponentSetup = context2.getInstallationComponentById(componentConfig.getId());
            try {
                context2.runScript(this.getSelectionChangedScript(), this, installationComponentSetup, dependency);
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
    }

    private static class ComponentConsoleState {
        public int index = 1;
        public String defaultConsoleSelection;
        public Map<Integer, ComponentNodeConfig> indexToComponentNodeConfig = new LinkedHashMap<Integer, ComponentNodeConfig>();
        public Map<Integer, ComponentNodeConfig> helpIndexToComponentNodeConfig = new LinkedHashMap<Integer, ComponentNodeConfig>();
        public Set<ComponentNodeConfig> mandatoryComponents = new HashSet<ComponentNodeConfig>();

        private ComponentConsoleState() {
        }
    }
}

