/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.runtime.beans.AllowDirectFieldAccess;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;

public abstract class AbstractLabelComponent
extends SystemFormComponent {
    private String labelText = "";
    private Color labelColor = null;
    private Font labelFont = null;
    private FontType labelFontType = FontType.DEFAULT;
    private FontStyle labelFontStyle = FontStyle.UNCHANGED;
    private int labelFontSizePercent = 100;

    public static Font translateFont(Font font, JComponent component) {
        if (font.getSize() == 0) {
            return font.deriveFont((float)component.getFont().getSize());
        }
        return font;
    }

    public String getLabelText() {
        return AbstractLabelComponent.replaceVariables(this.replaceFormVariables(this.labelText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    @AllowDirectFieldAccess
    protected String getRawLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public Color getLabelColor() {
        return this.replaceWithTextOverride("labelColor", this.labelColor, Color.class);
    }

    public void setLabelColor(Color labelColor2) {
        this.labelColor = labelColor2;
    }

    public Font getLabelFont() {
        return this.replaceWithTextOverride("labelFont", this.labelFont, Font.class);
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public FontType getLabelFontType() {
        return this.replaceWithTextOverride("labelFontType", this.labelFontType, FontType.class);
    }

    public void setLabelFontType(FontType labelFontType) {
        this.labelFontType = labelFontType;
    }

    public FontStyle getLabelFontStyle() {
        return this.replaceWithTextOverride("labelFontStyle", this.labelFontStyle, FontStyle.class);
    }

    public void setLabelFontStyle(FontStyle labelFontStyle) {
        this.labelFontStyle = labelFontStyle;
    }

    public int getLabelFontSizePercent() {
        return this.replaceWithTextOverride("labelFontSizePercent", this.labelFontSizePercent);
    }

    public void setLabelFontSizePercent(int labelFontSizePercent) {
        this.labelFontSizePercent = labelFontSizePercent;
    }

    protected void applyLabelColorAndFont(Color labelColor2, Font labelFont, FontType fontType, FontStyle fontStyle, int fontSizePercent, JComponent label) {
        if (labelColor2 != null) {
            label.setForeground(labelColor2);
        }
        this.applyFont(labelFont, fontType, fontStyle, fontSizePercent, label);
    }

    protected void applyFont(Font font, FontType fontType, FontStyle fontStyle, int fontSizePercent, JComponent component) {
        switch (fontType) {
            case DERIVED: {
                component.setFont(this.deriveFont(component.getFont(), fontStyle, fontSizePercent));
                break;
            }
            case CUSTOM: {
                if (font == null) break;
                component.setFont(AbstractLabelComponent.translateFont(font, component));
            }
        }
    }

    private Font deriveFont(Font font, FontStyle fontStyle, int fontSizePercent) {
        if (fontStyle != FontStyle.UNCHANGED) {
            font = font.deriveFont(fontStyle.getStyle());
        }
        if (fontSizePercent != 100) {
            font = font.deriveFont(1.0f * (float)Math.round(font.getSize2D() * (float)fontSizePercent / 100.0f));
        }
        return font;
    }
}

