/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateConfig;
import com.install4j.runtime.launcher.integration.UpdateLog;
import java.io.File;
import java.util.Arrays;

public class ScheduleUpdateAction
extends SystemInstallAction {
    private File installerFile;
    private String version = "";
    private int maxTries = 3;
    private int maxCancelCount = 10;
    private boolean checkNewerVersion = false;
    private String[] arguments;
    private int retryInhibitionMinutes = 1440;

    @Override
    public void init(Context context2) {
        super.init(context2);
        if (UpdateLog.setUpdaterApplication(true)) {
            UpdateLog.log(5, "starting installer application with 'Schedule update installation' action.");
        }
    }

    @Override
    public boolean install(InstallerContext context2) throws UserCanceledException {
        File installerFile = this.getInstallerFile();
        String installerPath = installerFile.getAbsolutePath();
        try {
            AutomaticUpdate.cleanupAllSuccessfulInstallations(installerPath);
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
        }
        UpdateLog.log(1, "scheduling " + installerPath);
        UpdateConfig.withConfig(true, updateConfig -> {
            updateConfig.clear();
            updateConfig.setFile(installerPath);
            updateConfig.setRetryInhibitionMinutes(this.getRetryInhibitionMinutes());
            updateConfig.setVersion(this.getVersion());
            updateConfig.setMaxTries(this.getMaxTries());
            updateConfig.setMaxCancelCount(this.getMaxCancelCount());
            updateConfig.setCheckNewerVersion(this.isCheckNewerVersion());
            if (InstallerConfig.isInstaller()) {
                updateConfig.setInstallationDirectory(FileUtil.getCanonicalPath(context2.getInstallationDirectory()));
            } else {
                File installationDir = null;
                File singleBundle = AutomaticUpdate.getCurrentSingleBundle();
                if (singleBundle != null) {
                    installationDir = singleBundle.getParentFile();
                } else {
                    File runtimeDir = ResourceHelper.getRuntimeDir();
                    if (runtimeDir != null) {
                        installationDir = runtimeDir.getParentFile();
                    }
                }
                if (installationDir != null) {
                    updateConfig.setInstallationDirectory(FileUtil.getCanonicalPath(installationDir));
                }
            }
            updateConfig.setLanguageId(context2.getLanguageId());
            String[] arguments2 = this.getArguments();
            if (arguments2 != null) {
                updateConfig.setArguments(Arrays.asList(arguments2));
            }
            return true;
        });
        return true;
    }

    public boolean isCheckNewerVersion() {
        return this.replaceWithTextOverride("checkNewerVersion", this.checkNewerVersion);
    }

    public void setCheckNewerVersion(boolean checkNewerVersion) {
        this.checkNewerVersion = checkNewerVersion;
    }

    public int getRetryInhibitionMinutes() {
        return this.replaceWithTextOverride("retryInhibitionMinutes", this.retryInhibitionMinutes);
    }

    public void setRetryInhibitionMinutes(int retryInhibitionMinutes) {
        this.retryInhibitionMinutes = retryInhibitionMinutes;
    }

    public int getMaxTries() {
        return this.replaceWithTextOverride("maxTries", this.maxTries);
    }

    public void setMaxTries(int maxTries) {
        this.maxTries = maxTries;
    }

    public int getMaxCancelCount() {
        return this.replaceWithTextOverride("maxCancelCount", this.maxCancelCount);
    }

    public void setMaxCancelCount(int maxCancelCount) {
        this.maxCancelCount = maxCancelCount;
    }

    public String[] getArguments() {
        return this.replaceWithTextOverride("arguments", ScheduleUpdateAction.replaceVariables(this.arguments), String[].class);
    }

    public void setArguments(String[] arguments2) {
        this.arguments = arguments2;
    }

    public File getInstallerFile() {
        return this.replaceWithTextOverride("installerFile", ScheduleUpdateAction.replaceVariables(this.installerFile), File.class);
    }

    public void setInstallerFile(File installerFile) {
        this.installerFile = installerFile;
    }

    public String getVersion() {
        return ScheduleUpdateAction.replaceVariables(ScheduleUpdateAction.replaceVariables(this.version));
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

