/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.text;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public class ReadTextFromFileAction
extends SystemInstallOrUninstallAction {
    private File file = null;
    private String variableName = "";
    private String encoding = "";
    private boolean saveAsArray = false;

    public File getFile() {
        return this.replaceWithTextOverride("file", ReadTextFromFileAction.replaceVariables(this.file), File.class);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getEncoding() {
        return ReadTextFromFileAction.replaceVariables(ReadTextFromFileAction.replaceVariables(this.encoding));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getVariableName() {
        return ReadTextFromFileAction.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isSaveAsArray() {
        return this.replaceWithTextOverride("saveAsArray", this.saveAsArray);
    }

    public void setSaveAsArray(boolean saveAsArray) {
        this.saveAsArray = saveAsArray;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        String encoding = this.getEncoding();
        File actualFile = context2.getDestinationFile(this.getFile());
        try {
            String value = InstallerUtil.readTextFile(actualFile, encoding);
            context2.setVariable(this.getVariableName(), this.maybeSplit(value));
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    private Object maybeSplit(String value) {
        if (this.isSaveAsArray()) {
            return value.split("\\R");
        }
        return value;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

