/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.text;

import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.files.AbstractModifyTextFileAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Objects;

public abstract class AbstractModifyTextFileInMemoryAction
extends AbstractModifyTextFileAction {
    protected abstract String modifyText(String var1, File var2);

    @Override
    protected boolean modifyFile(File file, Context context2) throws IOException {
        OutputStreamWriter writer;
        String origin2;
        if (file.length() > 0x6400000L) {
            Logger.getInstance().error(this, "file is to large");
            return false;
        }
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        byte[] bytes = new byte[(int)file.length()];
        in.readFully(bytes);
        in.close();
        String encoding = this.getEncoding();
        if (encoding != null && encoding.trim().length() > 0) {
            try {
                origin2 = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException e) {
                Logger.getInstance().log(e);
                origin2 = new String(bytes);
            }
        } else {
            origin2 = new String(bytes);
        }
        bytes = null;
        String result2 = this.modifyText(origin2, file);
        if (encoding != null && encoding.trim().length() > 0) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            }
            catch (UnsupportedEncodingException e) {
                Logger.getInstance().log(e);
                writer = new OutputStreamWriter(new FileOutputStream(file));
            }
        } else {
            writer = new OutputStreamWriter(new FileOutputStream(file));
        }
        writer.write(result2);
        ((Writer)writer).close();
        return this.handleFound(!Objects.equals(result2, origin2));
    }
}

