/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesReadAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.VariableEncoding;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class LoadInstallerVariablesAction
extends PreferencesReadAction {
    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        return this.executePreferencesReader(new LoadInstallerVariablesPreferencesReader(), context2);
    }

    private static class LoadInstallerVariablesPreferencesReader
    implements PreferencesReadAction.PreferencesReader {
        private LoadInstallerVariablesPreferencesReader() {
        }

        @Override
        public boolean readFromPreferences(Preferences packageNode, Context context2) throws BackingStoreException {
            String[] keys2 = packageNode.keys();
            if (keys2 == null || keys2.length == 0) {
                Logger.getInstance().log(this, "No installer variables found", false);
                return false;
            }
            HashMap<String, String> encodedVariables = new HashMap<String, String>();
            for (String key : keys2) {
                encodedVariables.put(key, packageNode.get(key, null));
            }
            Map<String, Object> decodedVariables = VariableEncoding.decodeVariables(encodedVariables, false);
            for (Map.Entry<String, Object> entry : decodedVariables.entrySet()) {
                context2.setVariable(entry.getKey(), entry.getValue());
            }
            return true;
        }
    }
}

