/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.beans.actions.registry.PreferencesDeleteAction;
import com.install4j.runtime.installer.helper.Logger;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class DeletePreferenceItemAction
extends PreferencesDeleteAction {
    private String key = "";
    private boolean onlyIfEmpty = true;

    public String getKey() {
        return DeletePreferenceItemAction.replaceVariables(DeletePreferenceItemAction.replaceVariables(this.key));
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isOnlyIfEmpty() {
        return this.replaceWithTextOverride("onlyIfEmpty", this.onlyIfEmpty);
    }

    public void setOnlyIfEmpty(boolean onlyIfEmpty) {
        this.onlyIfEmpty = onlyIfEmpty;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        if (this.getKey().trim().length() == 0 && this.getPackageName().trim().length() == 0) {
            return false;
        }
        return this.executePreferencesDeleter(new DeleteItemPreferencesDeleter(this.getKey(), this.isOnlyIfEmpty()), context2);
    }

    private static class DeleteItemPreferencesDeleter
    implements PreferencesDeleteAction.PreferencesDeleter {
        private String key;
        private boolean onlyIfEmpty;

        public DeleteItemPreferencesDeleter(String key, boolean onlyIfEmpty) {
            this.key = key.trim();
            this.onlyIfEmpty = onlyIfEmpty;
        }

        @Override
        public boolean deleteFromPreferences(PreferencesAction.PackageNodeProvider packageNodeProvider, Context context2, List<PreferencesAction.PreferencesRollbackAction> rollbackActions) throws BackingStoreException {
            Preferences packageNode = packageNodeProvider.getPackageNode();
            if (this.key.length() == 0) {
                if (this.onlyIfEmpty && (packageNode.childrenNames().length > 0 || packageNode.keys().length > 0)) {
                    Logger.getInstance().log(this, "Node is not empty", false);
                    return false;
                }
                PreferencesDeleteAction.deleteNode(packageNodeProvider, rollbackActions);
                return true;
            }
            return PreferencesDeleteAction.deleteKey(packageNodeProvider, this.key, rollbackActions);
        }
    }
}

