/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.properties.AbstractPropertiesFileAction;
import com.install4j.runtime.beans.actions.properties.LineSeparator;
import com.install4j.runtime.beans.actions.properties.PropertiesFileParameters;
import com.install4j.runtime.beans.actions.properties.PropertiesWriteParameters;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public class RemovePropertiesAction
extends AbstractPropertiesFileAction {
    private String[] keyNames;

    public String[] getKeyNames() {
        return this.replaceWithTextOverride("keyNames", RemovePropertiesAction.replaceVariables(this.keyNames), String[].class);
    }

    public void setKeyNames(String[] keyNames) {
        this.keyNames = keyNames;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        File usedFile = this.resolveRelativeFile(this.getFile(), context2);
        TextProperties properties2 = new TextProperties();
        if (!usedFile.exists()) {
            Logger.getInstance().error(this, "The properties file " + usedFile + " does not exist.");
            return false;
        }
        PropertiesFileParameters parameters2 = new PropertiesFileParameters(this.getEncoding(), this.getCharsetName());
        try {
            properties2.read(usedFile, parameters2);
        }
        catch (IOException e) {
            Logger.getInstance().error(this, "Could not read properties file");
            Logger.getInstance().log(e);
            return false;
        }
        if (context2 instanceof InstallerContext && !this.isSuppressRollback()) {
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(usedFile, true);
            backupAction.install((InstallerContext)context2);
            this.addRollbackAction(backupAction);
        }
        this.removeProperties(properties2);
        LineSeparator lineSeparator = parameters2.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = LineSeparator.SYSTEM;
        }
        PropertiesWriteParameters writeParameters = new PropertiesWriteParameters(this.getEncoding(), this.getCharsetName(), lineSeparator);
        try {
            properties2.write(usedFile, writeParameters);
        }
        catch (IOException e) {
            Logger.getInstance().error(this, "Could not write properties file");
            Logger.getInstance().log(e);
            return false;
        }
        return true;
    }

    private void removeProperties(TextProperties properties2) {
        String[] keyNames = this.getKeyNames();
        if (keyNames != null) {
            for (String keyName : keyNames) {
                properties2.remove(keyName);
            }
        }
    }
}

