/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.properties.AbstractPropertiesFileAction;
import com.install4j.runtime.beans.actions.properties.PropertiesFileParameters;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ReadPropertiesFileAction
extends AbstractPropertiesFileAction {
    private String variableName;
    private boolean merge;

    public String getVariableName() {
        return ReadPropertiesFileAction.replaceVariables(this.variableName);
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isMerge() {
        return this.replaceWithTextOverride("merge", this.merge);
    }

    public void setMerge(boolean merge2) {
        this.merge = merge2;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        File usedFile = this.resolveRelativeFile(this.getFile(), context2);
        if (!usedFile.exists()) {
            Logger.getInstance().error(this, "The file " + usedFile.getAbsolutePath() + " does not exist.");
            return false;
        }
        PropertiesFileParameters parameters2 = new PropertiesFileParameters(this.getEncoding(), this.getCharsetName());
        TextProperties properties2 = this.getTextProperties(context2);
        try {
            properties2.read(usedFile, parameters2);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        context2.setVariable(this.getVariableName(), properties2);
        return true;
    }

    private TextProperties getTextProperties(Context context2) {
        TextProperties textProperties = new TextProperties();
        Object existingValue = context2.getVariable(this.getVariableName());
        if (this.isMerge()) {
            if (existingValue instanceof TextProperties) {
                return (TextProperties)existingValue;
            }
            if (existingValue instanceof Map) {
                Map map2 = (Map)existingValue;
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator2.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null) continue;
                    textProperties.put(key.toString(), value.toString());
                }
            }
        }
        return textProperties;
    }
}

