/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.net.AbstractHttpRequestAction;
import com.install4j.runtime.beans.actions.net.HttpUploadMethod;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Uploader;
import java.io.File;
import java.io.IOException;

public class UploadFileAction
extends AbstractHttpRequestAction {
    private File file;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean retryIfInterrupted = true;
    private HttpUploadMethod uploadMethod = HttpUploadMethod.POST;

    public File getFile() {
        return this.replaceWithTextOverride("file", UploadFileAction.replaceVariables(this.file), File.class);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isShowProgress() {
        return this.replaceWithTextOverride("showProgress", this.showProgress);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileName() {
        return this.replaceWithTextOverride("showFileName", this.showFileName);
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public boolean isRetryIfInterrupted() {
        return this.replaceWithTextOverride("retryIfInterrupted", this.retryIfInterrupted);
    }

    public void setRetryIfInterrupted(boolean retryIfInterrupted) {
        this.retryIfInterrupted = retryIfInterrupted;
    }

    public HttpUploadMethod getUploadMethod() {
        return this.replaceWithTextOverride("uploadMethod", this.uploadMethod, HttpUploadMethod.class);
    }

    public void setUploadMethod(HttpUploadMethod uploadMethod) {
        this.uploadMethod = uploadMethod;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        boolean bl;
        block12: {
            File file = context2.getDestinationFile(this.getFile());
            ProgressInterface progressInterface = context2.getProgressInterface();
            if (this.isShowProgress()) {
                if (this.isShowFileName()) {
                    String fileName = file.getName();
                    progressInterface.setStatusMessage(this.wrapMessageInNobr(Messages.format(Messages.getString(".UploadingWithFileName"), "<b>" + fileName + "</b>")));
                } else {
                    progressInterface.setStatusMessage(Messages.getString(".Uploading"));
                }
            } else {
                progressInterface = new NoPercentageProgressDelegate(progressInterface);
            }
            Uploader uploader = this.createUploader(context2, this.isShowProgress() ? progressInterface : null);
            try {
                bl = UploadFileAction.doUpload(uploader, context2, file, this.getUrl(), this.isRetryIfInterrupted());
                if (uploader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (uploader != null) {
                        try {
                            uploader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getInstance().error(this, "Could not upload file");
                    Logger.getInstance().log(e);
                    return false;
                }
            }
            uploader.close();
        }
        return bl;
    }

    private Uploader createUploader(Context context2, ProgressInterface progressInterface) {
        Uploader uploader = new Uploader(context2, progressInterface);
        this.applyCommonProperties(uploader);
        uploader.setUploadMethod(this.getUploadMethod());
        return uploader;
    }

    private static boolean doUpload(Uploader uploader, Context context2, File file, String url, boolean retryIfInterrupted) throws IOException, UserCanceledException {
        boolean retry2;
        do {
            try {
                int responseCode = uploader.upload(url, file);
                boolean success2 = responseCode / 200 == 1;
                Logger.getInstance().log(null, "Upload finished with response code " + responseCode, success2);
                return success2;
            }
            catch (IOException e) {
                if (retryIfInterrupted) {
                    Logger.getInstance().error(null, "Could not upload file");
                    Logger.getInstance().log(e);
                    retry2 = UploadFileAction.askRetry(Messages.getString(".UploadInterrupted"));
                    continue;
                }
                throw e;
            }
            catch (UserCanceledException e) {
                if (context2.isCancelling()) {
                    throw e;
                }
                return false;
            }
        } while (retry2);
        return false;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

