/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DualDigest
extends MessageDigest {
    private final MessageDigest md5;
    private final MessageDigest sha256;

    public DualDigest(boolean useSha256, boolean useMd5) {
        super("SHA-256_AND_MD5");
        try {
            this.md5 = useMd5 ? MessageDigest.getInstance("MD5") : null;
            this.sha256 = useSha256 ? MessageDigest.getInstance("SHA-256") : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void engineReset() {
        DualDigest.reset(this.md5);
        DualDigest.reset(this.sha256);
    }

    private static void reset(MessageDigest md) {
        if (md != null) {
            md.reset();
        }
    }

    @Override
    public void engineUpdate(byte input) {
        DualDigest.update(this.md5, input);
        DualDigest.update(this.sha256, input);
    }

    private static void update(MessageDigest md, byte input) {
        if (md != null) {
            md.update(input);
        }
    }

    @Override
    public void engineUpdate(byte[] input, int offset2, int len) {
        DualDigest.update(this.md5, input, offset2, len);
        DualDigest.update(this.sha256, input, offset2, len);
    }

    private static void update(MessageDigest md, byte[] input, int offset2, int len) {
        if (md != null) {
            md.update(input, offset2, len);
        }
    }

    @Override
    public byte[] engineDigest() {
        return new byte[0];
    }

    public MessageDigest getMd5() {
        return this.md5;
    }

    public MessageDigest getSha256() {
        return this.sha256;
    }
}

