/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class RunExecutableAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    public static final String PROPERTY_ARGUMENTS = "arguments";
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean useRollbackExecutable = false;
    private File rollbackExecutable;
    private File rollbackWorkingDirectory;
    private String[] rollbackArguments;
    private boolean wait = false;
    private boolean waitForStreams = true;
    private String returnCodeVariable = "";
    private int timeout = 0;
    private boolean logArguments = false;
    private OutputRedirectionMode stdoutRedirectionMode = OutputRedirectionMode.NONE;
    private String stdoutVariableName = "";
    private boolean updateStdoutVariableLines = false;
    private File stdoutFile;
    private boolean failOnStdoutFileError = false;
    private OutputRedirectionMode stderrRedirectionMode = OutputRedirectionMode.NONE;
    private File stderrFile;
    private String stderrVariableName = "";
    private boolean updateStderrVariableLines = false;
    private boolean failOnStderrFileError = false;
    private InputRedirectionMode stdinRedirectionMode = InputRedirectionMode.NONE;
    private File stdinFile;
    private String stdinString = "";
    private boolean failOnStdinFileError = false;
    private boolean includeParentEnvironmentVariables = true;
    private Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;

    public File getExecutable() {
        return this.replaceWithTextOverride("executable", RunExecutableAction.replaceVariables(this.executable), File.class);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public File getWorkingDirectory() {
        return this.replaceWithTextOverride("workingDirectory", RunExecutableAction.replaceVariables(this.workingDirectory), File.class);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String[] getArguments() {
        return this.replaceWithTextOverride(PROPERTY_ARGUMENTS, RunExecutableAction.replaceVariables(this.arguments), String[].class);
    }

    public void setArguments(String[] arguments2) {
        this.arguments = arguments2;
    }

    public boolean isUseRollbackExecutable() {
        return this.replaceWithTextOverride("useRollbackExecutable", this.useRollbackExecutable);
    }

    public void setUseRollbackExecutable(boolean useRollbackExecutable) {
        this.useRollbackExecutable = useRollbackExecutable;
    }

    public File getRollbackExecutable() {
        return this.replaceWithTextOverride("rollbackExecutable", RunExecutableAction.replaceVariables(this.rollbackExecutable), File.class);
    }

    public void setRollbackExecutable(File rollbackExecutable) {
        this.rollbackExecutable = rollbackExecutable;
    }

    public File getRollbackWorkingDirectory() {
        return this.replaceWithTextOverride("rollbackWorkingDirectory", RunExecutableAction.replaceVariables(this.rollbackWorkingDirectory), File.class);
    }

    public void setRollbackWorkingDirectory(File rollbackWorkingDirectory) {
        this.rollbackWorkingDirectory = rollbackWorkingDirectory;
    }

    public String[] getRollbackArguments() {
        return this.replaceWithTextOverride("rollbackArguments", RunExecutableAction.replaceVariables(this.rollbackArguments), String[].class);
    }

    public void setRollbackArguments(String[] rollbackArguments) {
        this.rollbackArguments = rollbackArguments;
    }

    public boolean isWait() {
        return this.replaceWithTextOverride("wait", this.wait);
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean isWaitForStreams() {
        return this.replaceWithTextOverride("waitForStreams", this.waitForStreams);
    }

    public void setWaitForStreams(boolean waitForStreams) {
        this.waitForStreams = waitForStreams;
    }

    public String getReturnCodeVariable() {
        return RunExecutableAction.replaceVariables(this.returnCodeVariable);
    }

    public void setReturnCodeVariable(String returnCodeVariable) {
        this.returnCodeVariable = returnCodeVariable;
    }

    public int getTimeout() {
        return this.replaceWithTextOverride("timeout", this.timeout);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isLogArguments() {
        return this.replaceWithTextOverride("logArguments", this.logArguments);
    }

    public void setLogArguments(boolean logArguments) {
        this.logArguments = logArguments;
    }

    public OutputRedirectionMode getStdoutRedirectionMode() {
        return this.replaceWithTextOverride("stdoutRedirectionMode", this.stdoutRedirectionMode, OutputRedirectionMode.class);
    }

    public void setStdoutRedirectionMode(OutputRedirectionMode stdoutRedirectionMode) {
        this.stdoutRedirectionMode = stdoutRedirectionMode;
    }

    public String getStdoutVariableName() {
        return RunExecutableAction.replaceVariables(RunExecutableAction.replaceVariables(this.stdoutVariableName));
    }

    public void setStdoutVariableName(String stdoutVariableName) {
        this.stdoutVariableName = stdoutVariableName;
    }

    public boolean isUpdateStdoutVariableLines() {
        return this.replaceWithTextOverride("updateStdoutVariableLines", this.updateStdoutVariableLines);
    }

    public void setUpdateStdoutVariableLines(boolean updateStdoutVariableLines) {
        this.updateStdoutVariableLines = updateStdoutVariableLines;
    }

    public File getStdoutFile() {
        return this.replaceWithTextOverride("stdoutFile", RunExecutableAction.replaceVariables(this.stdoutFile), File.class);
    }

    public void setStdoutFile(File stdoutFile) {
        this.stdoutFile = stdoutFile;
    }

    public boolean isFailOnStdoutFileError() {
        return this.replaceWithTextOverride("failOnStdoutFileError", this.failOnStdoutFileError);
    }

    public void setFailOnStdoutFileError(boolean failOnStdoutFileError) {
        this.failOnStdoutFileError = failOnStdoutFileError;
    }

    public OutputRedirectionMode getStderrRedirectionMode() {
        return this.replaceWithTextOverride("stderrRedirectionMode", this.stderrRedirectionMode, OutputRedirectionMode.class);
    }

    public void setStderrRedirectionMode(OutputRedirectionMode stderrRedirectionMode) {
        this.stderrRedirectionMode = stderrRedirectionMode;
    }

    public String getStderrVariableName() {
        return RunExecutableAction.replaceVariables(RunExecutableAction.replaceVariables(this.stderrVariableName));
    }

    public void setStderrVariableName(String stderrVariableName) {
        this.stderrVariableName = stderrVariableName;
    }

    public boolean isUpdateStderrVariableLines() {
        return this.replaceWithTextOverride("updateStderrVariableLines", this.updateStderrVariableLines);
    }

    public void setUpdateStderrVariableLines(boolean updateStderrVariableLines) {
        this.updateStderrVariableLines = updateStderrVariableLines;
    }

    public File getStderrFile() {
        return this.replaceWithTextOverride("stderrFile", RunExecutableAction.replaceVariables(this.stderrFile), File.class);
    }

    public void setStderrFile(File stderrFile) {
        this.stderrFile = stderrFile;
    }

    public boolean isFailOnStderrFileError() {
        return this.replaceWithTextOverride("failOnStderrFileError", this.failOnStderrFileError);
    }

    public void setFailOnStderrFileError(boolean failOnStderrFileError) {
        this.failOnStderrFileError = failOnStderrFileError;
    }

    public InputRedirectionMode getStdinRedirectionMode() {
        return this.replaceWithTextOverride("stdinRedirectionMode", this.stdinRedirectionMode, InputRedirectionMode.class);
    }

    public void setStdinRedirectionMode(InputRedirectionMode stdinRedirectionMode) {
        this.stdinRedirectionMode = stdinRedirectionMode;
    }

    public String getStdinString() {
        return RunExecutableAction.replaceVariables(RunExecutableAction.replaceVariables(this.stdinString));
    }

    public void setStdinString(String stdinString) {
        this.stdinString = stdinString;
    }

    public File getStdinFile() {
        return this.replaceWithTextOverride("stdinFile", RunExecutableAction.replaceVariables(this.stdinFile), File.class);
    }

    public void setStdinFile(File stdinFile) {
        this.stdinFile = stdinFile;
    }

    public boolean isFailOnStdinFileError() {
        return this.replaceWithTextOverride("failOnStdinFileError", this.failOnStdinFileError);
    }

    public void setFailOnStdinFileError(boolean failOnStdinFileError) {
        this.failOnStdinFileError = failOnStdinFileError;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.replaceWithTextOverride("includeParentEnvironmentVariables", this.includeParentEnvironmentVariables);
    }

    public void setIncludeParentEnvironmentVariables(boolean includeParentEnvironmentVariables) {
        this.includeParentEnvironmentVariables = includeParentEnvironmentVariables;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.replaceWithTextOverride("environmentVariables", this.environmentVariables, Map.class);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean isShowWindowsConsole() {
        return this.replaceWithTextOverride("showWindowsConsole", this.showWindowsConsole);
    }

    public void setShowWindowsConsole(boolean showWindowsConsole) {
        this.showWindowsConsole = showWindowsConsole;
    }

    public boolean isKeepConsoleWindow() {
        return this.replaceWithTextOverride("keepConsoleWindow", this.keepConsoleWindow);
    }

    public void setKeepConsoleWindow(boolean keepConsoleWindow) {
        this.keepConsoleWindow = keepConsoleWindow;
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        if (Objects.equals(propertyName, PROPERTY_ARGUMENTS) && !this.isLogArguments()) {
            return "[logging of arguments is disabled]";
        }
        return propertyValue;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        return this.runExecutable(this.getExecutable(), this.getWorkingDirectory(), this.getArguments(), context2);
    }

    private boolean runExecutable(File executable, File workingDirectory, String[] arguments2, Context context2) {
        Integer returnValue;
        File workingDir;
        for (workingDir = context2.getDestinationFile(workingDirectory); workingDir != null && !workingDir.exists(); workingDir = workingDir.getParentFile()) {
        }
        Logger.getInstance().info(this, "used working dir: " + workingDir);
        File usedExecutable = this.getUsedExecutable(workingDir, context2, executable);
        if (!usedExecutable.exists()) {
            Logger.getInstance().error(this, "executable does not exist: " + usedExecutable.getAbsolutePath());
            return false;
        }
        OutputRedirection stdoutRedirection = new OutputRedirection(this.getStdoutRedirectionMode(), this.getStdoutVariableName(), this.isUpdateStdoutVariableLines(), this.getStdoutFile(), this.isFailOnStdoutFileError());
        OutputRedirection stderrRedirection = new OutputRedirection(this.getStderrRedirectionMode(), this.getStderrVariableName(), this.isUpdateStderrVariableLines(), this.getStderrFile(), this.isFailOnStderrFileError());
        InputRedirection stdinRedirection = new InputRedirection(this.getStdinRedirectionMode(), this.getStdinString(), this.getStdinFile(), this.isFailOnStdinFileError());
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(usedExecutable).workingDirectory(workingDir).arguments(arguments2).specificEnvironmentVariables(this.getEnvironmentVariables()).includeParentEnvironmentVariables(this.isIncludeParentEnvironmentVariables()).showWindowsConsole(this.isShowWindowsConsole()).keepConsoleWindow(this.isKeepConsoleWindow()).useNohup(!this.isWait() && !Util.isWindows() && !Util.isMacOS()).stdoutRedirection(stdoutRedirection).stderrRedirection(stderrRedirection).stdinRedirection(stdinRedirection).wait(this.isWait()).waitForStreams(this.isWaitForStreams()).timeout(this.getTimeout());
        if (Util.isMacOS() && HelperCommunication.getInstance().isElevatedHelper()) {
            launchDescriptor.suidRoot(true);
        }
        if ((returnValue = LaunchHelper.launchApplication(launchDescriptor)) == null) {
            return false;
        }
        if (this.isWait()) {
            int code = returnValue;
            if (this.getReturnCodeVariable().length() > 0) {
                context2.setVariable(this.getReturnCodeVariable(), returnValue);
            }
            if (code != 0) {
                if (Boolean.getBoolean("install4j.returnCodeInfoLogging")) {
                    Logger.getInstance().info(this, "return value is " + code);
                } else {
                    Logger.getInstance().error(this, "return value is " + code);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isRollbackSupported() {
        return this.isUseRollbackExecutable();
    }

    @Override
    public void rollback(InstallerContext context2) {
        super.rollback(context2);
        this.runExecutable(this.getRollbackExecutable(), this.getRollbackWorkingDirectory(), this.getRollbackArguments(), context2);
    }

    private File getUsedExecutable(File workingDir, Context context2, File executable) {
        File workingDirExecutable;
        File usedExecutable = this.maybeWithExtension(context2.getDestinationFile(executable));
        if (!usedExecutable.exists() && !executable.isAbsolute() && (workingDirExecutable = this.maybeWithExtension(new File(workingDir, executable.getPath()))).exists()) {
            usedExecutable = workingDirExecutable;
        }
        return usedExecutable;
    }

    private File maybeWithExtension(File file) {
        if (Util.isWindows() && !file.exists() && !file.getPath().toLowerCase(Locale.ENGLISH).endsWith(".exe")) {
            File fileWithExtension = new File(file.getPath() + ".exe");
            if (fileWithExtension.exists()) {
                return fileWithExtension;
            }
            return file;
        }
        return file;
    }
}

