/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;
import com.install4j.runtime.beans.actions.misc.RequestPrivilegesAction;
import com.install4j.runtime.installer.InstallerVariables;
import java.util.Objects;

public class RequireInstallerPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean failIfNotObtained = true;

    public boolean isFailIfNotObtained() {
        return this.replaceWithTextOverride("failIfNotObtained", this.failIfNotObtained);
    }

    public void setFailIfNotObtained(boolean failIfNotObtained) {
        this.failIfNotObtained = failIfNotObtained;
    }

    @Override
    public boolean execute(Context context2) throws UserCanceledException {
        boolean adminRightsRequired = Objects.equals(Boolean.TRUE, InstallerVariables.getVariable("sys.adminRights"));
        if (!(!adminRightsRequired || Util.isAdminGroup() && Util.hasFullAdminRights())) {
            if (Util.isWindows()) {
                return this.handleResult(this.startOnWindows(context2), context2);
            }
            if (Util.isMacOS()) {
                return this.handleResult(this.startOnMac(context2), context2);
            }
            if (RequestPrivilegesAction.isLinuxPrivilegeHandling()) {
                boolean success2 = false;
                if (!Objects.equals(Boolean.TRUE, InstallerVariables.getVariable("sys.adminRightsUiRootUnix"))) {
                    success2 = this.startOnLinux(context2);
                }
                return this.handleResult(success2, context2);
            }
            return this.handleResult(false, context2);
        }
        return true;
    }

    private boolean handleResult(boolean success2, Context context2) throws UserCanceledException {
        this.setAdminRightsVariable();
        if (!success2 && this.isFailIfNotObtained()) {
            this.showFailureMessage(context2);
        }
        return success2;
    }
}

